<?php
$encabezados = ["ID", "Nombre Completo", "Usuario", "Area", "Estado", "Acciones"];
include_once '../cliente/components/utilidades-tabla.php';
?>

<div class="w-full flex justify-center px-4">
  <div class="w-full max-w-none min-w-0">
    <section class="bg-white p-4 rounded shadow max-w-full overflow-hidden min-w-0">
      <div class="flex gap-2 items-end mb-4 flex-wrap">
        <div>
          <label class="text-xs">Buscar</label>
          <div class="flex items-center gap-2">
            <select id="usuarios-search-by" class="border text-xs border-gray-300 rounded px-2 py-1 h-8">
              <option value="todos">Todos</option>
              <option value="id">ID</option>
              <option value="nombre">Nombre</option>
              <option value="usuario">Usuario</option>
            </select>
            <div class="flex items-stretch">
              <input id="texto-buscar" class="border px-3 text-sm h-8 rounded-l-md rounded-r-none w-72 md:w-96 lg:w-[32rem]" placeholder="Escribe y presiona Enter">
              <button id="button-reload-search" title="Limpiar búsqueda" class="inline-flex items-center justify-center px-3 h-8 bg-gray-200 text-gray-700 rounded-r-md rounded-l-none hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-300 border border-gray-300 border-l-0">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>
        </div>
        <button id="button-search-users" class="bg-primary text-white px-3 py-1 rounded text-sm" disabled>Buscar</button>
      </div>

      <div class="flex items-center gap-3 text-xs text-gray-600 mb-2 pl-2">
        <label id="totalUsuarios">Total: 0</label>
        <label class="text-xs">Por pagina</label>
        <select id="pageSizeUsuarios" class="border text-xs border-gray-300 rounded px-2 py-1">
          <option value="10" selected>10</option>
          <option value="20">20</option>
          <option value="25">25</option>
          <option value="50">50</option>
          <option value="100">100</option>
        </select>
      </div>

      <div id="tabla-scroll" class="w-full max-w-full max-h-[70vh] overflow-auto bg-white rounded pr-6 md:pr-8 box-border min-w-0">
        <table class="tabla-mini tabla-usuarios table-sticky-first table-comfy table-spacious min-w-full w-full text-left text-xs">
          <thead class="sticky top-0 z-20 bg-gray-800 text-white">
            <tr>
              <?php mostrarTx($encabezados, 0); ?>
            </tr>
          </thead>
          <tbody class="bg-white divide-y divide-gray-200" id="tabla-usuarios-body">

          </tbody>
        </table>
      </div>

      <div id="pagination-container" class="p-2 sticky bottom-0 bg-white"></div>
    </section>
  </div>
</div>

<script type="module" src="<?php echo $base?>assets/js/usuarios/tabla.js"></script>
