<?php
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('requerimientos');

$pageTitle = 'Requerimientos por atender';
$activeMenu = 'requerimientos';

include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen w-full py-6 pr-4 md:pr-6">
    <div class="w-fit max-w-full px-4">
        <div class="flex flex-wrap items-center gap-4 bg-white p-3 rounded-lg shadow-md mb-2">
            <button id="btn-abrir-modal" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded text-xs uppercase transition-colors duration-200"
                title="Agregar Requerimiento">Agregar<br>Requerimiento
            </button>
            <div class="flex flex-col">
                <label class="block text-xs font-medium text-gray-700 mb-0.5">Buscar Por:</label>
            </div>
            <div class="flex flex-col">
                <select id="filtro-por" class="border text-xs border-gray-300 rounded-l px-1 py-1 focus:outline-none focus:ring-1 focus:ring-primary">
                    <option class="text-xs" value="">Seleccione</option>
                    <option class="text-xs" value="id_cliente">ID / Numero cliente</option>
                    <option class="text-xs" value="usuario">Usuario</option>
                    <option class="text-xs" value="fecha_requerimiento">Fecha Requerimiento</option>
                    <option class="text-xs" value="empresa">Empresa</option>
                    <option class="text-xs" value="requerimiento">Requerimientos</option>
                    <option class="text-xs" value="derivado">Origen</option>
                    <option class="text-xs" value="status">Status</option>
                    <option class="text-xs" value="nombres">Nombres</option>
                    <option class="text-xs" value="apellidos">Apellidos</option>
                    <option class="text-xs" value="fecha_respuesta_cliente">Fecha Respuesta Cliente</option>
                    <option class="text-xs" value="fecha_atencion">Fecha Atencion</option>
                    <option class="text-xs" value="email">Email</option>
                    <option class="text-xs" value="direccion">Direccion</option>
                    <option class="text-xs" value="telefono">Telefono</option>
                    <option class="text-xs" value="celular">Celular</option>
                </select>
            </div>
            <input id="texto-buscar" type="text" placeholder="Buscar"
                class="border text-xs border-gray-300 rounded-r px-2 py-1 focus:outline-none focus:ring-1 focus:ring-primary">
            <button id="button-search-filters"
                class="bg-primary hover:bg-primary/80 text-white text-xs font-medium py-1 px-3 rounded">
                <i class="fas fa-search mr-1 text-xs"></i>
                Buscar
            </button>
            <div class="flex flex-col">
                <button id="btnActualizarResultado"
                    class="bg-red-500 hover:bg-red-600 text-white text-xs font-medium py-1 px-3 rounded"
                    onclick="limpiarcamposac()">
                    <svg xmlns="http://www.w3.org/2000/svg"
                        class="inline-block mr-1 w-3 h-3"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                    </svg>
                    Actualizar
                </button>
            </div>
        </div>

        <div class="table-controls text-xs">
            <div class="max-w-[100vw]">
                <label class="text-xs" for="rowsPerPage">Mostrar por pagina:</label>
                <select id="rowsPerPage" onchange="updateRowsPerPage()">
                    <option class="text-xs" value="10">10</option>
                    <option class="text-xs" value="50">50</option>
                    <option class="text-xs" value="100">100</option>
                </select>
            </div>
        </div>
        <div class="table-container">
            <table class="custom-table">
                <thead class="thead-dark">
                    <tr>
                        <th class="text-xs rounded-tl-lg">Acciones</th>
                        <th class="text-xs">Nro</th>
                        <th class="text-xs">Usuario</th>
                        <th class="text-xs">Fecha Requerimiento</th>
                        <th class="text-xs">Empresa</th>
                        <th class="text-xs">Requerimiento</th>
                        <th class="text-xs">Origen</th>
                        <th class="text-xs">Status</th>
                        <th class="text-xs">Nombre</th>
                        <th class="text-xs">Apellido</th>
                        <th class="text-xs">Fecha Respuesta Cliente</th>
                        <th class="text-xs">Fecha Atencion</th>
                        <th class="text-xs">Email</th>
                        <th class="text-xs">Direccion</th>
                        <th class="text-xs">Telefono</th>
                        <th class="text-xs">Celular</th>
                        <th class="text-xs">Adjunto</th>
                        <th class="text-xs rounded-tr-lg">URL Pagina</th>

                    </tr>
                </thead>
                <tbody id="tableBody">

                </tbody>
            </table>
            <div class="w-full">
                <div class="max-w-[100vw] ">
                    <div id="pagination-container" class="pagination-controls text-left">
                        <!-- paginacion -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php include __DIR__ . '/modal.php'; ?>
<?php include __DIR__ . '/../cliente/modal.php'; ?>
<?php include __DIR__ . '/modal-editar.php'; ?>

<script type="module" src="<?php echo $base ?>assets/js/requerimientos/dashboard.js"></script>
<script src="<?php echo $base ?>assets/js/modal-cliente.js"></script>
<script src="<?php echo $base ?>assets/js/modal-distrito.js"></script>
<script type="module" src="<?php echo $base ?>assets/js/requerimientos/modal-add-req.js"></script>
<script type="module" src="<?php echo $base ?>assets/js/requerimientos/modal-edit-req.js"></script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>

<style>
    thead tr th {
        background-color: black !important;
        color: white !important;
        font-size: 16px;
        font-weight: 700;
    }

    .custom-table {
        width: max-content;
        min-width: 98.5%;
        border-collapse: collapse;
        font-size: 14px;
        border-bottom-right-radius: 12px !important;
        border-bottom-left-radius: 12px !important;
    }

    .custom-table th,
    .custom-table td {
        padding: 8px 16px;
        text-align: left;
        border-bottom: 1px solid #e5e7eb;
    }

    .custom-table th {
        background-color: #f3f4f6;
        font-weight: 600;
        white-space: nowrap;
    }

    .custom-table tbody tr:hover {
        background-color: rgb(207, 220, 233);
    }

    .table-controls {
        display: flex;
        justify-content: flex-start;
        margin-bottom: 16px;
    }

    .table-controls label {
        margin-right: 8px;
        font-size: 14px;
        line-height: 32px;
    }

    .table-controls select {
        padding: 6px;
        border: 1px solid #d1d5db;
        border-radius: 4px;
        font-size: 14px;
    }

    .table-container {
        overflow-x: visible;
        width: 100%;
        max-height: calc(100vh - 200px);
        overflow-y: visible;
        margin-top: 0.5rem;
    }

    .table-container thead th {
        position: sticky;
        top: 0;
        background-color: #f9fafb;
        z-index: 10;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .table-container th {
        padding: 12px 8px;
        font-weight: 600;
        text-align: left;
        border-bottom: 2px solid #e5e7eb;
    }

    .pagination-controls {
        display: flex;
        justify-content: center;
        padding: 1rem 0;
        margin-top: 1rem;
        margin-bottom: auto;
        background: #F3F4F6;
        border-top: 1px solid #e5e7eb;
        width: 100%;
    }

    .table-container {
        display: flex;
        flex-direction: column;
        min-height: 0;
    }
</style>
