<div id="modal-req" class="fixed inset-0 bg-black/50 z-50 hidden items-center justify-center">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-6xl p-5 max-h-[90vh] overflow-y-auto">
    <div class="flex items-center justify-between mb-3">
      <div>
        <h2 class="text-lg font-semibold" id="modal-title">Nuevo Requerimiento</h2>
        <p class="text-xs text-gray-600">Completa los campos y guarda.</p>
      </div>
      <button id="btn-close-modal" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="flex gap-2 mb-4">
      <button type="button" id="tab-datos-btn" class="px-3 py-1 bg-primary text-white rounded text-xs">Datos</button>
      <button type="button" id="tab-interacciones-btn" class="px-3 py-1 bg-gray-200 rounded text-xs hover:bg-gray-300">Interacciones</button>
      <button type="button" id="tab-cotizaciones-btn" class="px-3 py-1 bg-gray-200 rounded text-xs hover:bg-gray-300">Cotizaciones</button>
      <button type="button" id="tab-status-btn" class="px-3 py-1 bg-gray-200 rounded text-xs hover:bg-gray-300">Historial de Status</button>
    </div>

    <div id="tab-datos" class="space-y-3">
      <form id="form-requerimiento" class="space-y-3">
        <input type="hidden" name="id" id="req-id">
        <div class="grid md:grid-cols-4 gap-3">
          <div class="md:col-span-2">
            <div class="flex items-center justify-between">
              <label class="text-xs">Empresa *</label>
              <button type="button" id="btn-empresa-nuevo" class="text-xs bg-primary text-white px-2 py-1 rounded">+ Nuevo</button>
            </div>
            <div class="relative">
              <input id="req-empresa-input" class="border px-2 py-1 w-full text-sm" placeholder="Busca y selecciona empresa" autocomplete="off">
              <input id="req-empresa-id" name="empresa_id" type="hidden" required>
              <div id="req-empresa-dropdown" class="absolute left-0 right-0 mt-1 bg-white border border-gray-200 rounded shadow-lg max-h-60 overflow-auto hidden z-50"></div>
            </div>
            <p class="text-[11px] text-gray-500 mt-1">Escribe para filtrar empresas.</p>
          </div>
          <div class="md:col-span-2">
            <div class="flex items-center justify-between">
              <label class="text-xs">Contacto *</label>
              <button type="button" id="btn-contacto-nuevo" class="text-xs bg-primary text-white px-2 py-1 rounded">+ Nuevo</button>
            </div>
            <select id="req-contacto" name="contacto_id" class="border px-2 py-1 w-full text-sm rounded" required>
              <option value="">Seleccione contacto</option>
            </select>
            <p class="text-[11px] text-gray-500 mt-1">Solo contactos de la empresa seleccionada.</p>
          </div>
        </div>

        <div class="grid md:grid-cols-2 gap-3">         
          <label class="block text-xs">Título*
            <input name="titulo" id="req-titulo" type="text" class="w-full border rounded px-2 py-1 text-sm" required>
          </label>
        </div>

        <label class="block text-xs">Descripción
          <textarea name="descripcion" id="req-descripcion" class="w-full border rounded px-2 py-1 text-sm" rows="3"></textarea>
        </label>

        <div class="grid md:grid-cols-4 gap-3">
          <label class="block text-xs">Origen *
            <select name="origen" id="req-origen" class="w-full border rounded px-2 py-1 text-sm" required>
              <option value="">Seleccione</option>
              <option value="Whatsapp">Whatsapp</option>
              <option value="email">email</option>
              <option value="telefono">telefono</option>
              <option value="web">web</option>
              <option value="referido">referido</option>
              <option value="otro">otro</option>
            </select>
          </label>
          <label class="block text-xs">Tipo condicion de proyecto
            <select name="tipo_condicion_proyecto" id="req-tipo-condicion" class="w-full border rounded px-2 py-1 text-sm">
              <option value="">Seleccione</option>
              <option value="Estandar">Estandar</option>
              <option value="Urgente">Urgente</option>
              <option value="Muy Urgente">Muy Urgente</option>
            </select>
          </label>
          <label class="block text-xs">Nivel de tentativa
            <select name="nivel_tentativa" id="req-nivel-tentativa" class="w-full border rounded px-2 py-1 text-sm">
              <option value="">Seleccione</option>
              <option value="alto">Alto</option>
              <option value="medio">Medio</option>
              <option value="bajo">Bajo</option>
            </select>
          </label>
          <label class="block text-xs">Fecha requerida
            <input name="fecha_requerida" id="req-fecha" type="date" class="w-full border rounded px-2 py-1 text-sm">
          </label>
        </div>

        <div class="grid md:grid-cols-4 gap-3">
          <label class="block text-xs">Motivo compra
            <input name="motivo_compra" id="req-motivo-compra" type="text" class="w-full border rounded px-2 py-1 text-sm">
          </label>
          <label class="block text-xs">Forma de pago
            <input name="forma_pago" id="req-forma-pago" type="text" class="w-full border rounded px-2 py-1 text-sm">
          </label>          
          <label class="block text-xs">Categoria productos
            <input name="categoria_productos" id="req-categoria" type="text" class="w-full border rounded px-2 py-1 text-sm">
          </label>          
          <label class="block text-xs">Monto estimado
            <input name="monto_estimado" id="req-monto" type="number" step="0.01" class="w-full border rounded px-2 py-1 text-sm">
          </label>
          <label class="block text-xs">Prioridad
            <select name="prioridad" id="req-prioridad" class="w-full border rounded px-2 py-1 text-sm">
              <option value="">Seleccione</option>
              <option value="muy alta">Muy alta</option>
              <option value="alta">Alta</option>
              <option value="media">Media</option>
              <option value="baja">Baja</option>
            </select>
          </label>
          <label class="block text-xs">Etapa
            <select name="etapa" id="req-etapa" class="w-full border rounded px-2 py-1 text-sm">
              <option>Pendiente Atender</option>
              <option>En cotización</option>
              <option>Cotización enviada</option>
              <option>En Re-cotización</option>
              <option>No cotizado</option>
              <option>Cotización caída</option>
              <option>Cotización aprobada</option>
            </select>
          </label>
          <label class="block text-xs">Usuario apoyo
            <select name="usuario_apoyo_id" id="req-usuario-apoyo" class="w-full border rounded px-2 py-1 text-sm">
              <option value="">Seleccione</option>
            </select>
          </label>
        </div>

        <div class="flex gap-2 pt-1">
          <button type="submit" id="btn-save" class="bg-green-600 text-white px-4 py-1 rounded text-sm hover:bg-green-700 ml-auto">Guardar</button>
        </div>
      </form>
    </div>

    <div id="tab-interacciones" class="space-y-3 hidden">
      <div class="flex items-center justify-between mb-2">
        <h3 class="text-sm font-semibold">Interacciones</h3>
        <span class="text-xs text-gray-500">Guarda el requerimiento antes de agregar interacciones.</span>
      </div>
      <form id="form-interaccion" class="grid md:grid-cols-2 gap-3 mb-3">
        <label class="block text-xs">Canal
          <select id="int-canal" name="canal" class="w-full border rounded px-2 py-1 text-sm">
            <option value="">Seleccione</option>
            <option value="email">Email</option>
            <option value="whatsapp">Whatsapp</option>
            <option value="telefono">Telefono</option>
            <option value="reunion presencial">Reunion presencial</option>
            <option value="reunion virtual">Reunion virtual</option>
            <option value="otro">Otro</option>
          </select>
        </label>
        <label class="block text-xs">Próximo seguimiento
          <input id="int-proximo" name="proximo_seguimiento" type="datetime-local" class="w-full border rounded px-2 py-1 text-sm">
        </label>
        <label class="md:col-span-2 block text-xs">Resumen
          <textarea id="int-resumen" name="resumen" class="w-full border rounded px-2 py-1 text-sm" rows="2"></textarea>
        </label>
        <div class="flex items-center gap-2 text-xs">
          <input id="int-seguimiento" type="checkbox" class="h-4 w-4">
          <label for="int-seguimiento">Requiere seguimiento</label>
        </div>
        <div class="md:col-span-2 flex justify-end">
          <button type="button" id="btn-add-interaccion" class="bg-blue-600 text-white px-3 py-1 rounded text-sm hover:bg-blue-700">Agregar interacción</button>
        </div>
      </form>
      <div id="interacciones-container" class="timeline-grid grid gap-3 md:grid-cols-2 lg:grid-cols-3 max-h-56 overflow-auto text-sm border border-gray-200 rounded p-2 bg-gray-50">
        <div class="text-gray-500 text-xs">Sin interacciones.</div>
      </div>
    </div>

    <div id="tab-cotizaciones" class="space-y-3 hidden">
      <div class="flex items-center justify-between mb-2">
        <h3 class="text-sm font-semibold">Cotizaciones</h3>
        <span class="text-xs text-gray-500">Guarda el requerimiento antes de agregar cotizaciones.</span>
      </div>
      <form id="form-cotizacion" class="grid md:grid-cols-2 gap-3 mb-3">
        <label class="block text-xs">PDF de cotizacion
          <input id="cot-archivo" name="archivo" type="file" accept="application/pdf" class="w-full border rounded px-2 py-1 text-sm">
        </label>
        <label class="block text-xs">Monto
          <input id="cot-monto" name="monto" type="number" step="0.01" class="w-full border rounded px-2 py-1 text-sm">
        </label>
        <label class="md:col-span-2 block text-xs">Observaciones
          <textarea id="cot-observaciones" name="observaciones" class="w-full border rounded px-2 py-1 text-sm" rows="2"></textarea>
        </label>
        <div class="md:col-span-2 flex justify-end">
          <button type="button" id="btn-add-cotizacion" class="bg-blue-600 text-white px-3 py-1 rounded text-sm hover:bg-blue-700">Agregar cotizacion</button>
        </div>
      </form>
      <div id="cotizaciones-container" class="q-grid grid gap-3 md:grid-cols-2 lg:grid-cols-3 max-h-56 overflow-auto text-sm border border-gray-200 rounded p-2 bg-gray-50">
        <div class="text-gray-500 text-xs">Sin cotizaciones.</div>
      </div>
    </div>

    <div id="tab-status" class="space-y-3 hidden">
      <div class="flex items-center justify-between mb-2">
        <h3 class="text-sm font-semibold">Historial de Status</h3>
        <span class="text-xs text-gray-500">Solo lectura.</span>
      </div>
      <div id="status-container" class="space-y-2 max-h-56 overflow-auto text-sm border border-gray-200 rounded p-2 bg-gray-50">
        <div class="text-gray-500 text-xs">Sin historial.</div>
      </div>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../components/empresa_quick_modal.php'; ?>

<?php include __DIR__ . '/../components/contacto_quick_modal.php'; ?>

<style>
  :root{
    --cp-orange:#EB690B;
    --cp-black:#000000;
    --cp-gray:#666666;
    --cp-white:#FFFFFF;
    --cp-border:#e9ecef;
    --cp-bg:#f4f7f6;
  }

  .timeline-card{
    background: var(--cp-white);
    border-radius: 10px;
    border: 1px solid var(--cp-border);
    border-left: 4px solid var(--cp-gray);
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    padding: 12px 14px;
    display:flex;
    flex-direction:column;
    min-height: 180px;
  }

  .card-followup{
    border-left-color: var(--cp-orange);
    box-shadow: 0 0 0 3px rgba(235,105,11,.10);
  }

  .card-overdue{
    border-left-color: var(--cp-black);
    box-shadow: 0 0 0 3px rgba(0,0,0,.08);
  }

  .card-latest{
    border-color: #f59e0b;
    box-shadow: 0 0 0 3px rgba(245,158,11,.12);
  }

  .timeline-header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:10px;
    font-size: 0.85rem;
    color: var(--cp-gray);
    gap: 10px;
  }

  .channel-pill{
    display:inline-flex;
    align-items:center;
    gap:6px;
    padding:4px 10px;
    border-radius:999px;
    border:1px solid var(--cp-border);
    background:#f8f9fa;
    color: var(--cp-black);
    font-weight:700;
    font-size:.78rem;
    white-space:nowrap;
  }

  .comment{
    font-size: 0.95rem;
    color: #444;
    line-height: 1.4;
  }

  .comment-preview{ display:inline; }
  .comment-full{ display:none; }

  .follow-up-alert{
    background: rgba(235,105,11,.10);
    color: #6b3b05;
    padding: 8px 10px;
    border-radius: 8px;
    font-size: 0.82rem;
    margin-top: 10px;
    border-left: 4px solid var(--cp-orange);
    display:flex;
    justify-content:space-between;
    align-items:center;
    gap:10px;
  }

  .follow-up-alert .left,
  .follow-up-alert .right{ white-space: nowrap; }

  .followup-important{
    color: #dc2626;
    font-weight: 700;
  }

  .followup-overdue{
    color: var(--cp-black);
    font-weight: 700;
  }

  .follow-up-overdue{
    background: rgba(0,0,0,.06);
    border-left-color: var(--cp-black);
    color: #111;
  }

  .card-footer{
    margin-top:auto;
    padding-top: 10px;
    border-top: 1px solid #f0f0f0;
    display:flex;
    justify-content:space-between;
    align-items:center;
    gap: 10px;
  }

  .user-tag{ font-size: 0.78rem; color: var(--cp-gray); font-style: italic; }

  .btn-link{
    color: var(--cp-orange);
    text-decoration: none;
    background: none;
    border: none;
    padding: 0;
    font-size: 0.78rem;
    cursor: pointer;
  }
  .btn-link:hover{ text-decoration: underline; }

  .q-card{
    background: var(--cp-white);
    border-radius: 10px;
    border: 1px solid var(--cp-border);
    border-left: 4px solid var(--cp-gray);
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    padding: 12px 14px;
    display:flex;
    flex-direction:column;
    min-height: 170px;
  }

  .q-normal{ border-left-color: var(--cp-gray); }
  .q-latest{
    border-color: #f59e0b;
    box-shadow: 0 0 0 3px rgba(245,158,11,.12);
  }

  .q-head{
    display:flex;
    justify-content:space-between;
    align-items:flex-start;
    gap:10px;
    margin-bottom: 10px;
  }
  .q-title{
    font-weight: 800;
    color: var(--cp-black);
    line-height: 1.2;
  }
  .q-date{
    color: var(--cp-gray);
    font-size: .875rem;
    white-space: nowrap;
    margin-top: 2px;
    opacity: .95;
  }

  .q-amount{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding: 8px 10px;
    border: 1px solid var(--cp-border);
    border-radius: 10px;
    background: #fafafa;
    margin-bottom: 10px;
    font-size: .92rem;
  }
  .q-amount strong{ color: var(--cp-black); }
  .q-currency{ color: var(--cp-gray); font-size: .82rem; }

  .q-link{
    color: var(--cp-orange);
    text-decoration: none;
    font-weight: 700;
  }
  .q-link:hover{ text-decoration: underline; }

  .q-note{ color:#444; font-size: .92rem; line-height: 1.35; }
  .note-preview{ display:inline; }
  .note-full{ display:none; }

  .q-foot{
    margin-top:auto;
    padding-top: 10px;
    border-top: 1px solid #f0f0f0;
    display:flex;
    justify-content:space-between;
    align-items:center;
    gap:10px;
  }
  .q-user{ font-size:.78rem; color: var(--cp-gray); font-style: italic; }
</style>
