<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('requerimientos_v2');

$pageTitle = 'MODULO REQUERIMIENTOS V2';
$activeMenu = 'requerimientos_v2';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full">
  <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
    <section class="bg-white p-4 rounded shadow space-y-3">
      <div class="flex gap-2 items-end mb-2 flex-wrap">
        <div class="flex items-center gap-2">
          <input id="search-term" type="text" placeholder="Buscar por título/descr"
                 class="border border-gray-300 rounded px-2 py-1 text-sm w-72 md:w-96" />
          <button id="btn-refresh" class="bg-primary text-white px-3 py-1 rounded text-sm">Buscar</button>
        </div>
        <div class="flex items-center gap-2 ml-auto justify-end">
          
          <button id="btn-open-modal" class="bg-green-600 text-white px-3 py-1 rounded text-sm hover:bg-green-700">
            <i class="fas fa-plus"></i> Nuevo Requerimiento
          </button>
          
          
        </div>
      </div>

      <div class="flex items-center gap-3 text-xs text-black mb-2 pl-1 w-full justify-between">
        <div class="flex items-center gap-3">
          <label id="req-total">Total: 0</label>
          <div class="flex items-center gap-2">
            <label class="text-xs text-black">Por pagina</label>
            <select id="req-pageSize" class="border text-xs border-gray-300 rounded px-2 py-1">
              <option value="10">10</option>
              <option value="20">20</option>
              <option value="25" selected>25</option>
              <option value="50">50</option>
              <option value="100">100</option>
            </select>
          </div>
        </div>
        <div class="relative group pb-2">
          <button id="btn-columns" class="bg-slate-700 text-black px-3 py-1 rounded text-sm hover:bg-slate-800">
            Mostrar/Ocultar columnas
          </button>
          <div class="absolute right-0 top-full mt-0 w-56 bg-white border border-gray-200 rounded shadow-lg hidden group-hover:block group-focus-within:block z-50">
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="ruc">
              RUC
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="tipo_condicion_proyecto">
              Tipo condicion de proyecto
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="motivo_compra">
              Motivo compra
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="forma_pago">
              Forma de pago
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="nivel_tentativa">
              Nivel de tentativa
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="categoria_productos">
              Categoria productos
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="usuario_apoyo">
              Usuario apoyo
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="tipo_empresa">
              Tipo de Empresa
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="cargo">
              Cargo
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="telefono">
              Telefono
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="req-col-toggle" data-col="email">
              Email
            </label>
          </div>
        </div>
      </div>

      <div id="tabla-scroll-req" class="w-full max-h-[70vh] overflow-auto bg-white rounded pr-6 md:pr-8">
        <table class="tabla-mini table-sticky-first table-comfy table-spacious whitespace-nowrap min-w-[1600px] w-full text-left text-xs" id="tablaReq">
          <thead class="sticky top-0 z-20 bg-gray-800 text-white whitespace-nowrap">
            <tr>
              <th class="px-2 py-1 text-xs">ID</th>
              <th class="px-2 py-1 text-xs">Título Requerimiento</th>
              <th class="px-2 py-1 text-xs">Descripcion</th>
              <th class="px-2 py-1 text-xs" data-col="ruc">RUC</th>
              <th class="px-2 py-1 text-xs">Empresa</th>
              <th class="px-2 py-1 text-xs" data-col="tipo_empresa">Tipo de Empresa</th>
              <th class="px-2 py-1 text-xs">Contacto</th>
              <th class="px-2 py-1 text-xs" data-col="cargo">Cargo</th>
              <th class="px-2 py-1 text-xs" data-col="telefono">Telefono</th>
              <th class="px-2 py-1 text-xs" data-col="email">Email</th>
              <th class="px-2 py-1 text-xs">Origen</th>
              <th class="px-2 py-1 text-xs">Prioridad</th>
              <th class="px-2 py-1 text-xs" data-col="tipo_condicion_proyecto">Tipo condicion</th>
              <th class="px-2 py-1 text-xs" data-col="motivo_compra">Motivo compra</th>
              <th class="px-2 py-1 text-xs" data-col="forma_pago">Forma de pago</th>
              <th class="px-2 py-1 text-xs" data-col="nivel_tentativa">Nivel tentativa</th>
              <th class="px-2 py-1 text-xs" data-col="categoria_productos">Categoria productos</th>
              <th class="px-2 py-1 text-xs" data-col="usuario_apoyo">Usuario apoyo</th>
              <th class="px-2 py-1 text-xs">Etapa</th>
              <th class="px-2 py-1 text-xs">Lead</th>
              <th class="px-2 py-1 text-xs">Monto Estimado</th>
              <th class="px-2 py-1 text-xs">Monto Real</th>
              <th class="px-2 py-1 text-xs">Fecha Requerida</th>
              <th class="px-2 py-1 text-xs">Actualizado</th>
              <th class="px-2 py-1 text-xs">Usuario</th>
              <th class="px-2 py-1 text-xs">Acciones</th>
            </tr>
          </thead>
          <tbody id="tabla-requerimientos" class="bg-white divide-y divide-gray-200">
            <tr>
              <td class="px-2 py-1 text-gray-500 text-xs" colspan="26">Sin datos</td>
            </tr>
          </tbody>
        </table>
      </div>
      <div id="pagination-container" class="p-2 sticky bottom-0 bg-white"></div>
    </section>
  </div>
</main>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
<?php include __DIR__ . '/modal.php'; ?>
<script src="<?php echo $base ?>assets/js/static/sweetalert2.all.min.js" defer></script>
<script type="module" src="<?php echo $base ?>assets/js/requerimiento_v2/dashboard.js"></script>
