<div id="modalProviderProduct" class="fixed inset-0 bg-black/50 z-50 hidden items-start justify-center pt-20">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-6xl p-5 max-h-[90vh] overflow-y-auto">
    <div class="flex items-center justify-between mb-3">
      <h2 id="modalPpTitle" class="text-lg font-semibold">Nueva producto de proveedor</h2>
      <button id="btnCloseModalPp" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-1 gap-4">
      <div class="border rounded p-3">
        <h3 class="text-sm font-semibold mb-2">Producto</h3>
        <input type="hidden" id="m_pp_idprovprod">

        <div class="mb-2 grid grid-cols-1 md:grid-cols-4 gap-2">
          <div>
            <label class="text-xs">Producto</label>
            <div class="flex items-start gap-2">
              <div class="flex-1 flex flex-col gap-1">
                <input id="m_pp_prod_search" class="border px-2 py-1 w-full text-xs" placeholder="Buscar y seleccionar producto">
                <div id="m_pp_prod_suggestions" class="border border-gray-200 rounded bg-white max-h-40 overflow-auto text-xs hidden"></div>
              </div>
              <button id="btnPpNuevoProducto" class="bg-blue-600 text-white px-2 py-1 rounded text-xs h-8 mt-0.5">+ Nuevo</button>
              <!-- Select real (oculto) que mantiene la selección para la lógica actual -->
              <select id="m_pp_prodmodel_id" class="hidden">
                <option value=""></option>
              </select>
            </div>
          </div>
          <div id="pp_prod_preview" class="mt-2 hidden text-xs border rounded bg-gray-50 p-2">
            <div class="flex gap-2">
              <div class="w-16 h-16 flex items-center justify-center bg-white border rounded overflow-hidden">
                <img id="pp_prod_preview_img" src="" alt="Imagen del producto" class="max-w-full max-h-full hidden">
                <span id="pp_prod_preview_noimg" class="text-[10px] text-gray-400">Sin imagen</span>
              </div>
              <div class="flex-1">
                <div id="pp_prod_preview_title" class="font-semibold mb-0.5"></div>
                <div id="pp_prod_preview_cat" class="text-[11px] text-gray-500 mb-0.5"></div>
                <div id="pp_prod_preview_detail" class="text-[11px] text-gray-700"></div>
              </div>
            </div>
          </div>

          <div>
            <label class="text-xs">Proveedor</label>
            <select id="m_pp_provider_id" class="border px-2 py-1 w-full">
              <option value="">Seleccione proveedor</option>
            </select>
          </div>

          <div>
            <label class="text-xs">Codigo Producto proveedor</label>
            <input id="m_pp_provider_sku" class="border px-2 py-1 w-full" placeholder="Codigo producto usa el proveedor">
          </div>
        </div>
      </div>

      <div class="border rounded p-3">
        <h3 class="text-sm font-semibold mb-2">Precios y condiciones</h3>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <!-- Precio unitario dinámico -->
          <div class="mb-2">
            <div class="flex items-center justify-between">
              <label class="text-xs font-semibold">Precio unitario</label>
              <button id="btnAddPuRow" type="button" class="bg-blue-600 text-white px-2 py-1 rounded text-xs">
                + Otra línea
              </button>
            </div>
            <div id="pu_rows" class="mt-1 space-y-2">
              <!-- filas dinámicas de precio unitario -->
            </div>
          </div>

          <!-- Precio total dinámico -->
          <div class="mb-2">
            <div class="flex items-center justify-between">
              <label class="text-xs font-semibold">Precio total</label>
              <button id="btnAddPtRow" type="button" class="bg-blue-600 text-white px-2 py-1 rounded text-xs">
                + Otra línea
              </button>
            </div>
            <div id="pt_rows" class="mt-1 space-y-2">
              <!-- filas dinámicas de precio total -->
            </div>
          </div>
        </div>

        <div class="grid grid-cols-2 gap-2 mb-2">
          <div class="mb-2">
            <label class="text-xs">Detalle especifico del proveedor</label>
            <textarea id="m_pp_provider_detail" class="border px-2 py-1 w-full" rows="8" placeholder='{"logo":"bordado","talla":"M"}'></textarea>
          </div>

          <div class="mb-2">
            <label class="text-xs">Especificaciones del proveedor</label>
            <textarea id="m_pp_provider_specs" class="border px-2 py-1 w-full" rows="8" placeholder='{"observaciones":"..."}'></textarea>
          </div>
        </div>

        <div class="grid grid-cols-3 gap-2 mb-2">
          <div>
            <label class="text-xs">Tiempo de entrega (dias)</label>
            <input id="m_pp_lead_time_days" class="border px-2 py-1 w-full" placeholder="Ej. 15">
          </div>
          <div>
            <label class="text-xs">Dias de validez</label>
            <input id="m_pp_validity_days" class="border px-2 py-1 w-full" placeholder="Ej. 30">
          </div>
          <div>
            <label class="text-xs">Fecha de cotizacion</label>
            <input id="m_pp_quote_date" type="date" class="border px-2 py-1 w-full" max="<?php echo date('Y-m-d'); ?>">
          </div>
        </div>
      </div>
    </div>

    <div class="mt-4 flex justify-end gap-2">
      <button id="m_pp_cancelar" class="bg-gray-400 text-white px-3 py-1 rounded text-sm">Cancelar</button>
      <button id="m_pp_guardar" class="bg-green-600 text-white px-3 py-1 rounded text-sm">Guardar</button>
    </div>
  </div>
</div>

<!-- Modal pequeño para crear producto rápido -->
<div id="modalNuevoProductoPP" class="fixed inset-0 bg-black/40 z-50 hidden items-center justify-center">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-md p-5">
    <div class="flex items-center justify-between mb-3">
      <h2 class="text-lg font-semibold">Nuevo producto</h2>
      <button id="btnCloseModalNuevoProductoPP" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="grid grid-cols-1 gap-3">
      <div>
        <label class="text-xs">Nombre del producto</label>
        <input id="pp_np_name_prod" class="border px-2 py-1 w-full" placeholder="Ej. CAMISAS">
      </div>

      <div>
        <label class="text-xs">Categoría principal</label>
        <select id="pp_np_catg_id" class="border px-2 py-1 w-full">
          <option value="">Seleccione categoría</option>
        </select>
      </div>

      <div>
        <label class="text-xs">Nombre variante / modelo (opcional)</label>
        <input id="pp_np_variant_name" class="border px-2 py-1 w-full" placeholder="Ej. San Jacinto">
      </div>
    </div>

    <div class="mt-4 flex justify-end gap-2">
      <button id="pp_np_cancelar" class="bg-gray-400 text-white px-3 py-1 rounded text-sm">Cancelar</button>
      <button id="pp_np_guardar" class="bg-green-600 text-white px-3 py-1 rounded text-sm">Guardar</button>
    </div>
  </div>
</div>
