<div id="modalNuevo" class="fixed inset-0 bg-black/50 z-50 hidden items-center justify-center">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-5xl p-5 max-h-[80vh] overflow-y-auto">
    <div class="flex items-center justify-between mb-3">
      <h2 id="modalTitle" class="text-lg font-semibold">Nuevo Proveedor</h2>
      <button id="btnCloseModal" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="flex gap-2 mb-2">
      <button id="tabGeneralBtn" class="px-3 py-1 bg-primary text-white rounded text-xs">General</button>
      <button id="tabPerfilBtn" class="px-3 py-1 bg-gray-200 rounded text-xs hover:bg-gray-300">Perfil</button>
    </div>

    <!-- TAB GENERAL -->
    <div id="tabGeneral" class="grid grid-cols-1 md:grid-cols-4 gap-3">
      <!-- Fila: RUC / Razón Social / Razón Comercial -->
      <div class="md:col-span-2">
        <label class="text-xs">Identificador fiscal</label>
        <div class="flex flex-col gap-1">
          <div class="flex flex-wrap gap-2 w-full">
            <select id="m_ruc_tipo" class="border px-2 py-1 text-xs rounded w-28">
              <option value="RUC">RUC</option>
              <option value="CUIT">CUIT</option>
              <option value="VAT">VAT</option>
              <option value="TIN">TIN</option>
              <option value="NIT">NIT</option>
              <option value="NIF">NIF</option>
              <option value="OTRO">Otro</option>
            </select>
            <input id="m_ruc" class="border px-2 py-1 flex-1 min-w-0" placeholder="Ingresa el identificador">
            <button id="m_buscar_ruc" type="button" class="bg-blue-600 text-white px-3 py-1 rounded text-sm whitespace-nowrap flex items-center justify-center">Buscar RUC</button>
          </div>
          <p class="text-[11px] text-gray-500">Seleccione identificadores según corresponda.</p>
        </div>
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Razón Social</label>
        <input id="m_razon_social" class="border px-2 py-1 w-full" placeholder="Razón Social">
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Razón Comercial</label>
        <input id="m_razon_comercial" class="border px-2 py-1 w-full" placeholder="Razón Comercial">
      </div>

      <!-- Fila: Rubro / Condición / Estado -->
      <div class="md:col-span-1">
        <label class="text-xs">Rubro / Sector</label>
        <input id="m_rubro_sector" class="border px-2 py-1 w-full" placeholder="Rubro o sector">
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Condición Contribuyente</label>
        <input id="m_condicion" class="border px-2 py-1 w-full" placeholder="(ERP)" readonly>
      </div>
      <div class="md:col-span-2">
        <label class="text-xs">Estado Contribuyente</label>
        <input id="m_estado" class="border px-2 py-1 w-full" placeholder="(ERP)" readonly>
      </div>

      <!-- Fila: Tipo Proveedor / Calificación / Aniversario / Teléfono -->
      <div class="md:col-span-1">
        <label class="text-xs">Tipo Proveedor</label>
        <select id="m_tipo_provee" class="border px-2 py-1 w-full">
          <option value="" disabled selected>Seleccione tipo</option>
          <option value="nuevo">Nuevo</option>
          <option value="antiguo">Antiguo</option>
          <option value="otro">Otros</option>
        </select>
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Calificación</label>
        <select id="m_calificacion" class="border px-2 py-1 w-full">
          <option value="" disabled selected>Seleccione calificación</option>
          <option value="nacional">Nacional</option>
          <option value="importado">Importado</option>
          <option value="otro">Otros</option>
        </select>
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Aniversario</label>
        <input id="m_aniversario" type="date" class="border px-2 py-1 w-full">
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Teléfono</label>
        <input id="m_telefono" class="border px-2 py-1 w-full" placeholder="Teléfono">
      </div>

      <!-- Fila: Celular / Email / Página web -->
      <div class="md:col-span-1">
        <label class="text-xs">Celular</label>
        <input id="m_celular" class="border px-2 py-1 w-full" placeholder="Celular">
      </div>
      <div class="md:col-span-2">
        <label class="text-xs">Email</label>
        <input id="m_email" class="border px-2 py-1 w-full" placeholder="Email">
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Página web</label>
        <input id="m_paginaweb" class="border px-2 py-1 w-full" placeholder="https://...">
      </div>

      <!-- Fila: Origen / País / Distrito / Ciudad -->
      <div class="md:col-span-1">
        <label class="text-xs">Origen</label>
        <input id="m_origen" class="border px-2 py-1 w-full" placeholder="Origen (ej. Facebook)">
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">País</label>
        <input id="m_pais" class="border px-2 py-1 w-full" placeholder="País">
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Distrito</label>
        <input id="m_distrito" class="border px-2 py-1 w-full" placeholder="Distrito">
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Ciudad</label>
        <input id="m_ciudad" class="border px-2 py-1 w-full" placeholder="Ciudad">
      </div>

      <!-- Fila: Dirección (4 columnas) -->
      <div class="md:col-span-4">
        <label class="text-xs">Dirección</label>
        <input id="m_direccion" class="border px-2 py-1 w-full" placeholder="Dirección">
      </div>

      <!-- Fila: Referencia (4 columnas) -->
      <div class="md:col-span-4">
        <label class="text-xs">Referencia</label>
        <input id="m_referencia" class="border px-2 py-1 w-full" placeholder="Referencia">
      </div>

      <!-- Fila: Catálogos / Redes (2 columnas cada uno) -->
      <div class="md:col-span-2">
        <label class="text-xs font-semibold">Catálogos (URLs)</label>
        <div id="catalogosContainer" class="space-y-2 mt-1"></div>
        <button id="btnAddCatalogo" type="button" class="mt-1 bg-gray-200 px-2 py-1 rounded text-xs hover:bg-gray-300">+
          Agregar catálogo</button>
      </div>

      <div class="md:col-span-2">
        <label class="text-xs font-semibold">Redes Sociales (clave / URL)</label>
        <div id="redesContainer" class="space-y-2 mt-1"></div>
        <button id="btnAddRed" type="button" class="mt-1 bg-gray-200 px-2 py-1 rounded text-xs hover:bg-gray-300">+
          Agregar red</button>
      </div>
    </div>

    <!-- TAB PERFIL -->
    <div id="tabPerfil" class="hidden">
      <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
        <div class="md:col-span-2">
          <label class="text-xs">Resumen del perfil</label>
          <textarea id="perfil_resumen" class="border px-2 py-1 w-full" rows="2"
            placeholder="Proveedor especializado en..."></textarea>
        </div>
        <div class="md:col-span-2">
          <label class="text-xs">Capacidad de respuesta</label>
          <textarea id="perfil_respuesta" class="border px-2 py-1 w-full" rows="2"
            placeholder="Responde en ..."></textarea>
        </div>
        <div>
          <label class="text-xs">Tipo de pago</label>
          <input id="perfil_pago_tipo" class="border px-2 py-1 w-full" placeholder="Pago contra entrega o...">
        </div>
        <div class="md:col-span-2">
          <label class="text-xs">Número de cuenta</label>
          <input id="perfil_cuenta" class="border px-2 py-1 w-full" placeholder="BANCO XYZ - ...">
        </div>
        <div class="md:col-span-2">
          <label class="text-xs font-semibold">Productos que maneja</label>
          <div id="perfilProductosContainer" class="space-y-2 mt-1"></div>
          <button id="btnAddPerfilProd" type="button"
            class="mt-1 bg-gray-200 px-2 py-1 rounded text-xs hover:bg-gray-300">+ Agregar producto</button>
        </div>
        <div class="md:col-span-2">
          <label class="text-xs">Servicio</label>
          <textarea id="perfil_servicio" class="border px-2 py-1 w-full" rows="2" placeholder="Textil, ..."></textarea>
        </div>
        <div class="md:col-span-2">
          <label class="text-xs">Comentarios adicionales</label>
          <textarea id="perfil_comentarios" class="border px-2 py-1 w-full" rows="2" placeholder="..."></textarea>
        </div>
      </div>
    </div>

    <br>
    <button id="m_cancelar" class="bg-gray-400 text-white px-3 py-1 rounded text-sm">Cancelar</button>
    <button id="m_guardar" class="bg-green-600 text-white px-3 py-1 rounded text-sm">Guardar</button>
  </div>
</div>
