<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireRegularArea();

$pageTitle = 'MÓDULO PROVEEDORES';
$activeMenu = 'proveedores';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full">
  <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
    <section class="bg-white p-4 rounded shadow">
      <div class="flex gap-2 items-end mb-4 flex-wrap" >
        <div>
          <label class="text-xs">Buscar</label>
          <div class="flex items-center gap-2">
            <select id="prov-search-by" class="border text-xs border-gray-300 rounded px-2 py-1 h-8">
              <option value="todos">Todos</option>
              <option value="id">ID</option>
              <option value="ruc">RUC / ID fiscal</option>
              <option value="razon_social">Razón Social</option>
              <option value="email">Email</option>
              <option value="Teléfono">Telefono</option>
              <option value="usuario">Usuario</option>
            </select>
            <div class="flex items-stretch">
              <input id="q" class="border px-3 text-sm h-8 rounded-l-md rounded-r-none w-72 md:w-96 lg:w-[32rem]" placeholder="Escribe y presiona Enter">
              <button id="btnClearSearch" title="Limpiar busqueda" class="inline-flex items-center justify-center px-3 h-8 bg-gray-200 text-gray-700 rounded-r-md rounded-l-none hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-300 border border-gray-300 border-l-0">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>
        </div>
        <button id="btnBuscar" class="bg-primary text-white px-3 py-1 rounded text-sm">Buscar</button>
        <button id="btnNuevo" class="ml-auto bg-green-600 text-white px-3 py-1 rounded text-sm"> 
          <i class="fas fa-plus"></i>  Nuevo Proveedor
        </button>
      </div>

      <!-- Total y tamaño de página alineados al inicio de la columna ID -->
      <div class="flex items-center gap-3 text-xs text-gray-600 mb-2 pl-2">
        <label id="totalProveedores">Total: 0</label>
        <label class="text-xs">Por página</label>
        <select id="pageSize" class="border text-xs border-gray-300 rounded px-2 py-1">
          <option value="10">10</option>
          <option value="20">20</option>
          <option value="25" selected>25</option>
          <option value="50">50</option>
          <option value="100">100</option>
        </select>
      </div>
      

      <div id="tabla-scroll-top" class="hidden md:block h-3 overflow-x-auto overflow-y-hidden">
        <div id="tabla-scroll-top-inner" class="h-3"></div>
      </div>
      <div id="tabla-scroll" class="w-full max-h-[70vh] overflow-auto bg-white rounded pr-6 md:pr-8">
        <table class="tabla-mini table-sticky-first table-comfy table-spacious min-w-[1200px] w-full text-left text-xs" id="tablaProveedores">
          <thead class="sticky top-0 z-20 bg-gray-800 text-white">
            <tr>
              <th class="px-2 py-1 text-xs">ID</th>
              <th class="px-2 py-1 text-xs">Usuario</th>
              <th class="px-2 py-1 text-xs">ID fiscal (RUC / CUIT / VAT)</th>
              <th class="px-2 py-1 text-xs">Razón Social</th>
              <th class="px-2 py-1 text-xs">Razón Comercial</th>
              <th class="px-2 py-1 text-xs">Email</th>
              <th class="px-2 py-1 text-xs">Teléfono</th>
              <th class="px-2 py-1 text-xs">Celular</th>
              <th class="px-2 py-1 text-xs">Origen</th>
              <th class="px-2 py-1 text-xs">Página Web</th>
              <th class="px-2 py-1 text-xs">Dirección</th>
              <th class="px-2 py-1 text-xs">Fecha Actualización</th>
              <th class="px-2 py-1 text-xs">Acciones</th>
            </tr>
          </thead>
          <tbody id="tbodyProveedores" class="bg-white divide-y divide-gray-200">
            <tr>
              <td class="px-2 py-1 text-gray-500 text-xs" colspan="13">Sin datos</td>
            </tr>
          </tbody>
        </table>
      </div>

      <div id="pagination-container" class="p-2 sticky bottom-0 bg-white"></div>
    </section>

    <?php include __DIR__ . '/modal.php'; ?>
  </div>
</main>

<script src="<?php echo $base ?>assets/js/listar-clientes/tabla-ui.js"></script>
<script src="<?php echo $base ?>assets/js/proveedores/truncation.js"></script>
<script src="<?php echo $base ?>assets/js/proveedores/phone-validators.js"></script>
<script type="module">
  import { paginacion, updateRowsPerPage } from "<?php echo $base ?>assets/js/requerimientos/paginacion.js";
  window.provPaginacion = paginacion;
  window.updateProvRowsPerPage = updateRowsPerPage;
  // Inicializar según el select actual
  const sel = document.getElementById('pageSize');
  if (sel) {
    paginacion.rowsPerPage = parseInt(sel.value || '25', 10);
  }
  paginacion.renderFunction = () => { window.reloadProveedoresTable?.(); };
  window.dispatchEvent(new Event('proveedores-paginacion-ready'));
</script>
<script src="<?php echo $base ?>assets/js/proveedores/index.js" defer></script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>



