<!-- Modal para CRUD -->
<div id="modalNuevo" class="hidden fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
    <div class="bg-white rounded-lg shadow-lg w-11/12 md:w-full md:max-w-5xl xl:max-w-6xl max-h-[90vh] overflow-y-auto">
        <div class="flex justify-between items-center p-6 border-b border-gray-300">
        <h2 id="modalTitle" class="text-xl font-bold">Nuevo Contacto</h2>
        <button id="btnCloseModal" class="text-gray-500 hover:text-gray-700 text-2xl">×</button>
        </div>
        <div class="p-6">
            <div class="grid md:grid-cols-3 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nombre *</label>
                    <input type="text" id="m_nombre" class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none" required>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Apellido</label>
                    <input type="text" id="m_apellido" class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none">
                </div>
                <div class="md:col-span-1">
                    <div class="flex justify-between items-center">
                        <h3 class="block text-sm font-medium text-gray-700 mb-1">Proveedor *</h3>
                        <button type="button" id="btnAddProveedor" class="text-xs px-2 py-1 bg-green-600 text-white rounded hover:bg-green-700" title="Agregar proveedor">
                            <i class="fas fa-plus"></i> Agregar proveedor
                        </button>
                    </div>

                    <!-- Select original (se convertirá en combobox) -->
                    <select id="m_provee_select" class="hidden">
                        <option value="">Selecciona…</option>
                    </select>
                    <!-- Contenedor donde se inyectará el combobox searchable -->
                    <div id="proveeComboContainer"></div>
                    
                    <!-- Hidden para guardar el id seleccionado (compatibilidad) -->
                    <input type="hidden" id="m_provee_id">
                    <!-- Hidden para datos de proveedor (usado internamente por JS, no visible) -->
                    <input type="hidden" id="selectedProveerName">
                    <input type="hidden" id="selectedProveedorId">
                    <input type="hidden" id="selectedProveedorRuc">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Cargo</label>
                    <input type="text" id="m_cargo" class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Cumpleaños</label>
                    <input type="date" id="m_cumpleanios" class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Origen</label>
                    <input type="text" id="m_origen" class="w-full border border-gray-300 rounded px-3 py-2 focus:outline-none">
                </div>
                
            </div>

            <div class="grid md:grid-cols-3 gap-4">
                <!-- Emails -->
                <div class="mt-6">
                    <div class="flex justify-between items-center mb-2">
                        <h3 class="text-lg font-semibold text-gray-800">Emails</h3>
                        <button id="btnAddEmail" type="button" class="px-2 py-1 text-sm bg-blue-500 text-white rounded hover:bg-blue-600">
                            + Agregar Email
                        </button>
                    </div>
                    <div id="emailContainer" class="space-y-2"></div>
                </div>
                <!-- Teléfonos -->
                <div class="mt-6">
                    <div class="flex justify-between items-center mb-2">
                        <h3 class="text-lg font-semibold text-gray-800">Teléfonos</h3>
                        <button id="btnAddTelefono" type="button" class="px-2 py-1 text-sm bg-blue-500 text-white rounded hover:bg-blue-600">
                            + Agregar Teléfono
                        </button>
                    </div>
                    <div id="telefonoContainer" class="space-y-2"></div>
                </div>
    
                <!-- Celulares -->
                <div class="mt-6">
                    <div class="flex justify-between items-center mb-2">
                        <h3 class="text-lg font-semibold text-gray-800">Celulares</h3>
                        <button id="btnAddCelular" type="button" class="px-2 py-1 text-sm bg-blue-500 text-white rounded hover:bg-blue-600">
                            + Agregar Celular
                        </button>
                    </div>
                    <div id="celularContainer" class="space-y-2"></div>
                </div>
            </div>

        </div>

        <!-- Footer del modal -->
        <div class="flex gap-2 p-6 border-t border-gray-300 bg-gray-50">
            <button id="m_cancelar" class="px-4 py-2 bg-gray-300 text-gray-700 rounded hover:bg-gray-400 flex-1">Cancelar</button>
            <button id="m_guardar" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700 flex-1">Guardar</button>
        </div>
    </div>
</div>

<!-- Modal ligero: Nuevo Proveedor (embebido para flujo rápido) -->
<div id="prov_modal" class="hidden fixed inset-0 bg-black bg-opacity-50 z-50 items-center justify-center" style="z-index: 9999;">
  <div class="bg-white rounded-lg shadow-lg w-11/12 md:max-w-2xl p-5">
    <div class="flex items-center justify-between mb-4">
      <h2 class="text-lg font-semibold">Nuevo Proveedor</h2>
      <button id="prov_cerrar" class="text-gray-500 hover:text-gray-700" title="Cerrar">
        <i class="fas fa-times"></i>
      </button>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
      <div class="md:col-span-1">
        <label class="text-xs">RUC *</label>
        <input id="prov_ruc" class="border px-2 py-1 w-full" maxlength="11" placeholder="RUC" />
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Razón Social</label>
        <input id="prov_razon_social" class="border px-2 py-1 w-full" placeholder="Razón Social" />
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Razón Comercial</label>
        <input id="prov_razon_comercial" class="border px-2 py-1 w-full" placeholder="Razón Comercial" />
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Email</label>
        <input id="prov_email" class="border px-2 py-1 w-full" placeholder="correo@dominio.com" />
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Teléfono</label>
        <input id="prov_telefono" class="border px-2 py-1 w-full" placeholder="Teléfono" />
      </div>
      <div class="md:col-span-1">
        <label class="text-xs">Celular</label>
        <input id="prov_celular" class="border px-2 py-1 w-full" placeholder="Celular" />
      </div>
      <div class="md:col-span-2">
        <label class="text-xs">Página Web</label>
        <input id="prov_paginaweb" class="border px-2 py-1 w-full" placeholder="https://..." />
      </div>
    </div>
    <div class="flex gap-2 mt-4 justify-end">
      <button id="prov_cancelar" class="bg-gray-300 text-gray-800 px-3 py-1 rounded text-sm">Cancelar</button>
      <button id="prov_guardar" class="bg-green-600 text-white px-3 py-1 rounded text-sm">Guardar</button>
    </div>
  </div>
</div>
