<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireRegularArea();

$pageTitle = 'Modulo Provee Contacto';
$activeMenu = 'provee_contacto';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full">
  <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
    <div class="mx-auto w-[90%] p-4">
        <!-- Encabezado y filtros -->
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <div class="flex justify-between items-center mb-4">
                <div class="flex items-end gap-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">Buscar Por:</label>
                    <select id="campoBusqueda" class="border border-gray-300 rounded px-3 py-2">
                        <option value="todos" selected>Todos</option>
                        <option value="id">ID</option>
                        <option value="nombre">Nombre</option>
                        <option value="apellido">Apellido</option>
                        <option value="email">Email</option>
                        <option value="empresa">Empresa</option>
                        <option value="telefono">Telefono</option>
                        <option value="celular">Celular</option>
                        <option value="usuario">Usuario</option>
                    </select>
                    <input type="text" id="q" class="w-full border border-gray-300 rounded px-3 py-2" placeholder="Buscar...">
                    <button id="btnBuscar" class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700 flex-1">
                        <i class="fas fa-search"></i> Buscar
                    </button>
                </div>
                <button id="btnNuevo" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
                    <i class="fas fa-plus"></i> Nuevo Contacto
                </button>
            </div>            
        </div>

        <!-- Barra total y por pagina (consistente con otros modulos) -->
        <div class="flex items-center gap-3 text-xs text-gray-600 mb-2 pl-2">
          <label id="totalContactos">Total: 0</label>
          <label class="text-xs">Por pagina</label>
          <select id="pageSize" class="border text-xs border-gray-300 rounded px-2 py-1">
            <option value="10">10</option>
            <option value="20">20</option>
            <option value="25" selected>25</option>
            <option value="50">50</option>
            <option value="100">100</option>
          </select>
        </div>

        <!-- Tabla de contactos -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <div id="tabla-scroll-top" class="hidden md:block h-3 overflow-x-auto overflow-y-hidden">
              <div id="tabla-scroll-top-inner" class="h-3"></div>
            </div>
            <div id="tabla-scroll" class="w-full max-h-[70vh] overflow-auto bg-white rounded pr-6 md:pr-8">
                <table class="tabla-mini table-sticky-first table-comfy table-spacious min-w-[1200px] w-full text-left text-xs" id="tablaContactos">
                    <thead class="sticky top-0 z-20 bg-gray-800 text-white">
                        <tr>
                            <th class="px-2 py-1 text-xs">ID</th>
                            <th class="px-2 py-1 text-xs">Usuario</th>
                            <th class="px-2 py-1 text-xs">Empresa</th>
                            <th class="px-2 py-1 text-xs">Nombre</th>
                            <th class="px-2 py-1 text-xs">Apellido</th>
                            <th class="px-2 py-1 text-xs">Cargo</th>
                            <th class="px-2 py-1 text-xs">Email</th>
                            <th class="px-2 py-1 text-xs">Telefono</th>
                            <th class="px-2 py-1 text-xs">Celular</th>
                            <th class="px-2 py-1 text-xs">Cumpleanios</th>
                            <th class="px-2 py-1 text-xs">Fecha Actualizacion</th>
                            <th class="px-2 py-1 text-xs">Acciones</th>
                        </tr>
                    </thead>
                    <tbody id="tbodyContactos">
                        <tr>
                            <td class="px-2 py-1 text-gray-500 text-xs text-center" colspan="12">Sin datos</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div id="pagination-container" class="p-2 sticky bottom-0 bg-white"></div>
        </div>

        <?php include __DIR__ . '/modal.php'; ?>
    </div>
  </div>
</main>

<script src="<?php echo $base ?>assets/js/provee_contacto/truncation.js"></script>
<script src="<?php echo $base ?>assets/js/provee_contacto/index.js" defer></script>
<script type="module">
  import { paginacion, updateRowsPerPage } from "<?php echo $base ?>assets/js/requerimientos/paginacion.js";
  // Exponer para depuracion si hace falta
  window.contactosPaginacion = paginacion;
  window.updateContactRowsPerPage = () => updateRowsPerPage('pageSize');
  // Inicializar con el valor del select
  const sel = document.getElementById('pageSize');
  if (sel) {
    paginacion.rowsPerPage = parseInt(sel.value || '25', 10);
  }
  // Llamada de rerender cuando cambia paginacion
  paginacion.renderFunction = () => { window.reloadContactosTable?.(); };
  window.dispatchEvent(new Event('contactos-paginacion-ready'));
  // Sincronizar cambios del select con el helper compartido
  sel?.addEventListener('change', () => updateRowsPerPage('pageSize'));
</script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
