<div id="modalProducto" class="fixed inset-0 bg-black/50 z-50 hidden items-center justify-center">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-3xl p-6 max-h-[95vh] overflow-y-auto">
    <div class="flex items-center justify-between mb-3">
      <h2 id="modalProdTitle" class="text-lg font-semibold">Nuevo producto</h2>
      <button id="btnCloseModalProd" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <input type="hidden" id="m_idprodmodel">

      <div class="space-y-3">
        <div>
          <label class="text-xs">Nombre del producto</label>
          <input id="m_name_prod" class="border px-2 py-1 w-full" placeholder="Ej. CAMISAS">
        </div>

        <div>
          <label class="text-xs">Categoría principal</label>
          <div class="flex gap-2">
            <select id="m_catg_id" class="border px-2 py-1 w-full">
              <option value="">Seleccione categoría</option>
            </select>
            <button id="btnProdNuevaCat" type="button" class="bg-blue-600 text-white px-2 py-1 rounded text-xs">+ Nueva</button>
          </div>
        </div>

        <div>
          <label class="text-xs">Categorías adicionales</label>
          <div class="flex gap-2">
            <select id="m_catg_extra_select" class="border px-2 py-1 w-full">
              <option value="">Seleccione categoría adicional</option>
            </select>
            <button id="m_catg_extra_add" type="button" class="bg-blue-600 text-white px-2 py-1 rounded text-xs">Agregar</button>
          </div>
          <div id="m_catg_extra_tags" class="mt-1 flex flex-wrap gap-1 text-[11px]"></div>
          <input type="hidden" id="m_catg_ids">
        </div>

        <div>
          <label class="text-xs">Código variante (SKU interno)</label>
          <input id="m_variant_code" class="border px-2 py-1 w-full" placeholder="SKU interno">
        </div>

        <div>
          <label class="text-xs">Nombre variante / modelo</label>
          <input id="m_variant_name" class="border px-2 py-1 w-full" placeholder="Ej. San Jacinto">
        </div>
      </div>

      <div class="space-y-3">
        <div>
          <label class="text-xs">Detalle</label>
          <textarea id="m_detail" class="border px-2 py-1 w-full text-xs" rows="10" placeholder="Pega aquí el texto del detalle. Se guardará exactamente como lo pegues."></textarea>
        </div>

        <div>
          <label class="text-xs">Imagen del producto</label>
          <input id="m_img" type="hidden">
          <input id="m_img_file" type="file" accept="image/*" class="border px-2 py-1 w-full text-xs bg-white">
          <div class="mt-2">
            <img id="m_img_preview" src="" alt="Vista previa" class="max-h-40 object-contain border border-dashed border-gray-300 rounded w-full hidden">
          </div>
        </div>
      </div>
    </div>

    <div class="mt-4 flex justify-end gap-2">
      <button id="m_cancelar_prod" class="bg-gray-400 text-white px-3 py-1 rounded text-sm">Cancelar</button>
      <button id="m_guardar_prod" class="bg-green-600 text-white px-3 py-1 rounded text-sm">Guardar</button>
    </div>
  </div>
</div>

<!-- Modal pequeño para crear categoría rápida -->
<div id="modalNuevaCatProd" class="fixed inset-0 bg-black/40 z-50 hidden items-center justify-center">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-md p-5">
    <div class="flex items-center justify-between mb-3">
      <h2 class="text-lg font-semibold">Nueva categoría</h2>
      <button id="btnCloseModalNuevaCatProd" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="grid grid-cols-1 gap-3">
      <div>
        <label class="text-xs">Nombre de la categoría</label>
        <input id="np_cat_name" class="border px-2 py-1 w-full" placeholder="Nombre">
      </div>
      <div>
        <label class="text-xs">Descripción (opcional)</label>
        <textarea id="np_cat_desc" class="border px-2 py-1 w-full" rows="2" placeholder="Descripción"></textarea>
      </div>
    </div>

    <div class="mt-4 flex justify-end gap-2">
      <button id="np_cat_cancelar" class="bg-gray-400 text-white px-3 py-1 rounded text-sm">Cancelar</button>
      <button id="np_cat_guardar" class="bg-green-600 text-white px-3 py-1 rounded text-sm">Guardar</button>
    </div>
  </div>
</div>

