<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireRegularArea();

$pageTitle = 'MÓDULO PRODUCTOS / OFERTAS';
$activeMenu = 'productos';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full">
  <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
    <section class="bg-white p-4 rounded shadow">
      <div class="flex gap-2 items-end mb-4 flex-wrap">
        <div>
          <label class="text-xs">Buscar</label>
          <input id="prod_q" class="border px-3 text-sm h-8 rounded-md w-72 md:w-96 lg:w-[24rem]" placeholder="Buscar por nombre o modelo">
        </div>
        <button id="btnProdBuscar" class="bg-primary text-white px-3 py-1 rounded text-sm">Buscar</button>
        <button id="btnProdNuevo" class="ml-auto bg-green-600 text-white px-3 py-1 rounded text-sm">
          <i class="fas fa-plus"></i> Nuevo producto / oferta
        </button>
      </div>

      <div class="w-full max-h-[70vh] overflow-auto bg-white rounded pr-6 md:pr-8">
        <table class="tabla-mini table-sticky-first table-comfy table-spacious min-w-[900px] w-full text-left text-xs">
          <thead class="sticky top-0 z-20 bg-gray-800 text-white">
            <tr>
              <th class="px-2 py-1 text-xs">ID</th>
              <th class="px-2 py-1 text-xs">Nombre producto</th>
              <th class="px-2 py-1 text-xs">Modelo / Variante</th>
              <th class="px-2 py-1 text-xs">Categoría</th>
              <th class="px-2 py-1 text-xs">Estado</th>
              <th class="px-2 py-1 text-xs">Última actualización</th>
              <th class="px-2 py-1 text-xs">Acciones</th>
            </tr>
          </thead>
          <tbody id="tbodyProductos" class="bg-white divide-y divide-gray-200">
            <tr>
              <td class="px-2 py-1 text-gray-500 text-xs" colspan="7">Sin datos</td>
            </tr>
          </tbody>
        </table>
      </div>
    </section>

    <?php include __DIR__ . '/modal.php'; ?>
  </div>
</main>

<!-- Editor simple para el detalle (con tablas) -->
<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    if (typeof tinymce !== 'undefined') {
      tinymce.init({
        selector: '#m_detail',
        menubar: false,
        height: 260,
        plugins: 'table lists',
        toolbar: 'undo redo | bold italic underline | bullist numlist | table',
        branding: false
      });
    }
  });
</script>

<script src="<?php echo $base ?>assets/js/proveedores/truncation.js"></script>
<script src="<?php echo $base ?>assets/js/producto/index.js" defer></script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
