<?php
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('campanas');

$pageTitle = 'CONFIGURACION MAUTIC';
$activeMenu = 'mautic_config';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full">
    <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
        <section class="bg-white p-4 rounded shadow space-y-6">
            <div class="flex flex-wrap items-center justify-between gap-2">
                <div class="flex flex-wrap gap-2">
                    <button class="px-4 py-2 rounded bg-gray-100 text-gray-700 font-semibold" data-tab="instancias">Instancias Mautic</button>
                    <button class="px-4 py-2 rounded bg-gray-100 text-gray-700 font-semibold" data-tab="segmentos">Mapeo de Segmentos</button>
                    <button class="px-4 py-2 rounded bg-gray-100 text-gray-700 font-semibold" data-tab="reportes">Reporte All Emails</button>
                </div>
                <div class="flex flex-wrap gap-2">
                    <button id="btn-sync-push" class="bg-blue-600 text-white px-4 py-2 rounded">Subir contactos</button>
                    <button id="btn-sync-pull" class="bg-purple-600 text-white px-4 py-2 rounded">Traer campanas</button>
                    <button id="btn-sync-mautic" class="bg-purple-600 text-white px-4 py-2 rounded">Sincronizar ahora</button>
                </div>
            </div>
            <p id="sync_result" class="text-sm text-gray-500"></p>

            <div id="tab-instancias" class="tab-panel">
                <div class="flex flex-wrap items-center justify-between gap-2">
                    <div>
                        <h2 class="text-xl font-bold text-gray-800">Instancias Mautic</h2>
                        <p class="text-sm text-gray-500">Registra cada Mautic con su URL y credenciales (Basic u OAuth2).</p>
                    </div>
                    <button id="btn-open-instancia" class="bg-orange-600 text-white px-4 py-2 rounded">Nueva instancia</button>
                </div>
                <div class="mt-3 flex items-center gap-2">
                    <label class="text-sm text-gray-600">Filtrar por estado</label>
                    <select id="instancia_filter_estado" class="border rounded p-2 text-sm">
                        <option value="">Todas</option>
                        <option value="1">Activas</option>
                        <option value="0">Inactivas</option>
                    </select>
                </div>
                <div class="mt-4 overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead class="bg-gray-100 text-gray-600">
                            <tr>
                                <th class="text-left p-2">ID</th>
                                <th class="text-left p-2">Nombre</th>
                                <th class="text-left p-2">Base URL</th>
                                <th class="text-left p-2">Auth</th>
                                <th class="text-left p-2">Usuario</th>
                                <th class="text-left p-2">Activo</th>
                                <th class="text-left p-2">Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="instancias-body"></tbody>
                    </table>
                </div>
            </div>

            <div id="tab-segmentos" class="tab-panel hidden">
                <div class="flex flex-wrap items-center justify-between gap-2">
                    <div>
                        <h2 class="text-xl font-bold text-gray-800">Mapeo de Segmentos</h2>
                        <p class="text-sm text-gray-500">Asocia los segmentos clave (open/click/no open, CRM, etc.) por instancia.</p>
                    </div>
                    <button id="btn-open-segmento" class="bg-orange-600 text-white px-4 py-2 rounded">Nuevo segmento</button>
                </div>
                <div class="mt-3 flex items-center gap-2">
                    <label class="text-sm text-gray-600">Filtrar por instancia</label>
                    <select id="segmento_filter_instancia" class="border rounded p-2 text-sm">
                        <option value="">Todas</option>
                    </select>
                </div>
                <div class="mt-4 overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead class="bg-gray-100 text-gray-600">
                            <tr>
                                <th class="text-left p-2">ID</th>
                                <th class="text-left p-2">Instancia</th>
                                <th class="text-left p-2">Clave</th>
                                <th class="text-left p-2">ID Segmento</th>
                                <th class="text-left p-2">Descripcion</th>
                                <th class="text-left p-2">Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="segmentos-body"></tbody>
                    </table>
                </div>
            </div>

            <div id="tab-reportes" class="tab-panel hidden">
                <div class="flex flex-wrap items-center justify-between gap-2">
                    <div>
                        <h2 class="text-xl font-bold text-gray-800">Reporte All Emails</h2>
                        <p class="text-sm text-gray-500">Configura el reporte para obtener clicks reales por campana.</p>
                    </div>
                    <button id="btn-open-reporte" class="bg-orange-600 text-white px-4 py-2 rounded">Nuevo reporte</button>
                </div>
                <div class="mt-3 flex items-center gap-2">
                    <label class="text-sm text-gray-600">Filtrar por instancia</label>
                    <select id="reporte_filter_instancia" class="border rounded p-2 text-sm">
                        <option value="">Todas</option>
                    </select>
                </div>
                <div class="mt-4 overflow-x-auto">
                    <table class="w-full text-sm">
                        <thead class="bg-gray-100 text-gray-600">
                            <tr>
                                <th class="text-left p-2">ID</th>
                                <th class="text-left p-2">Instancia</th>
                                <th class="text-left p-2">Report Key</th>
                                <th class="text-left p-2">Report ID</th>
                                <th class="text-left p-2">Campo Campania</th>
                                <th class="text-left p-2">Campo Lead</th>
                                <th class="text-left p-2">Campo Clicks</th>
                                <th class="text-left p-2">Activo</th>
                                <th class="text-left p-2">Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="reportes-body"></tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>
</main>

<div id="modal-instancia" class="fixed inset-0 bg-black/40 hidden items-center justify-center z-50">
    <div class="bg-white rounded-lg shadow-lg w-full max-w-3xl p-6 max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-bold text-gray-800">Instancia Mautic</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700" data-close="modal-instancia">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form id="form-instancia" class="grid grid-cols-1 md:grid-cols-3 gap-3">
            <input type="hidden" id="instancia_id">
            <div>
                <input class="border rounded p-2 w-full" id="instancia_nombre" placeholder="Nombre">
                <p id="instancia_nombre_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="instancia_base_url" placeholder="Base URL">
                <p id="instancia_base_url_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <select class="border rounded p-2" id="instancia_auth_type">
                <option value="basic">Basic</option>
                <option value="oauth2">OAuth2</option>
            </select>
            <div class="basic-field">
                <input class="border rounded p-2 w-full" id="instancia_api_user" placeholder="Usuario API">
                <p id="instancia_api_user_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div class="basic-field">
                <input class="border rounded p-2 w-full" id="instancia_api_pass" placeholder="Password API">
                <p id="instancia_api_pass_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="instancia_min_campaign_id" placeholder="Campana desde ID (opcional)">
                <p id="instancia_min_campaign_id_error" class="text-xs text-red-500 hidden">Debe ser un numero.</p>
            </div>
            <div class="oauth-field">
                <input class="border rounded p-2 w-full" id="instancia_oauth_client_id" placeholder="OAuth Client ID">
                <p id="instancia_oauth_client_id_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div class="oauth-field">
                <input class="border rounded p-2 w-full" id="instancia_oauth_client_secret" placeholder="OAuth Client Secret">
                <p id="instancia_oauth_client_secret_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div class="oauth-field">
                <input class="border rounded p-2 w-full" id="instancia_oauth_redirect_uri" placeholder="OAuth Redirect URI">
                <p id="instancia_oauth_redirect_uri_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div class="oauth-field">
                <input class="border rounded p-2 w-full" id="instancia_oauth_access_token" placeholder="OAuth Access Token">
                <p id="instancia_oauth_access_token_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div class="oauth-field">
                <input class="border rounded p-2 w-full" id="instancia_oauth_refresh_token" placeholder="OAuth Refresh Token">
                <p id="instancia_oauth_refresh_token_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <label class="flex items-center gap-2 text-sm">
                <input type="checkbox" id="instancia_activo" checked>
                Activo
            </label>
            <div class="md:col-span-3 flex flex-wrap gap-2 items-center justify-between">
                <p id="instancia_test_result" class="text-sm text-gray-500"></p>
                <div class="flex gap-2 justify-end">
                    <button type="button" id="instancia_test" class="bg-blue-600 text-white px-4 py-2 rounded">Probar conexion</button>
                <button type="button" id="instancia_reset" class="bg-gray-200 text-gray-800 px-4 py-2 rounded">Limpiar</button>
                <button type="submit" id="instancia_save" class="bg-orange-600 text-white px-4 py-2 rounded">Guardar</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div id="modal-segmento" class="fixed inset-0 bg-black/40 hidden items-center justify-center z-50">
    <div class="bg-white rounded-lg shadow-lg w-full max-w-2xl p-6">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-bold text-gray-800">Mapeo de Segmento</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700" data-close="modal-segmento">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form id="form-segmento" class="grid grid-cols-1 md:grid-cols-2 gap-3">
            <input type="hidden" id="segmento_id">
            <div>
                <select class="border rounded p-2 w-full" id="segmento_instancia"></select>
                <p id="segmento_instancia_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="segmento_clave" placeholder="Clave (contactopenmail)">
                <p id="segmento_clave_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="segmento_id_mautic" placeholder="ID Segmento Mautic">
                <p id="segmento_id_mautic_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="segmento_desc" placeholder="Descripcion">
                <p id="segmento_desc_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div class="md:col-span-2 flex gap-2 justify-end">
                <button type="button" id="segmento_reset" class="bg-gray-200 text-gray-800 px-4 py-2 rounded">Limpiar</button>
                <button type="submit" id="segmento_save" class="bg-orange-600 text-white px-4 py-2 rounded">Guardar</button>
            </div>
        </form>
    </div>
</div>

<div id="modal-reporte" class="fixed inset-0 bg-black/40 hidden items-center justify-center z-50">
    <div class="bg-white rounded-lg shadow-lg w-full max-w-4xl p-6 max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-4">
            <h3 class="text-lg font-bold text-gray-800">Reporte All Emails</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700" data-close="modal-reporte">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <form id="form-reporte" class="grid grid-cols-1 md:grid-cols-3 gap-3">
            <input type="hidden" id="reporte_id">
            <div>
                <select class="border rounded p-2 w-full" id="reporte_instancia"></select>
                <p id="reporte_instancia_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_key" placeholder="report_key (all_emails)">
                <p id="reporte_key_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_report_id" placeholder="Report ID">
                <p id="reporte_report_id_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_campo_campania" placeholder="campo_campania (campaign_id)">
                <p id="reporte_campo_campania_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_campo_lead" placeholder="campo_lead_id (contactId)">
                <p id="reporte_campo_lead_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_campo_email" placeholder="campo_email (email_address)">
                <p id="reporte_campo_email_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_campo_subject" placeholder="campo_subject (subject)">
                <p id="reporte_campo_subject_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_campo_clicks" placeholder="campo_clicks (hits)">
                <p id="reporte_campo_clicks_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_campo_sent" placeholder="campo_date_sent (date_sent)">
                <p id="reporte_campo_sent_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <div>
                <input class="border rounded p-2 w-full" id="reporte_campo_read" placeholder="campo_date_read (date_read)">
                <p id="reporte_campo_read_error" class="text-xs text-red-500 hidden">Campo requerido.</p>
            </div>
            <label class="flex items-center gap-2 text-sm">
                <input type="checkbox" id="reporte_activo" checked>
                Activo
            </label>
            <div class="md:col-span-3 flex gap-2 justify-end">
                <button type="button" id="reporte_reset" class="bg-gray-200 text-gray-800 px-4 py-2 rounded">Limpiar</button>
                <button type="submit" id="reporte_save" class="bg-orange-600 text-white px-4 py-2 rounded">Guardar</button>
            </div>
        </form>
    </div>
</div>

<script src="<?php echo $base ?>assets/js/mautic/index.js"></script>
<?php include __DIR__ . '/../layout/layout_end.php'; ?>
