<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('logistica');

$pageTitle = 'MODULO LOGISTICA';
$activeMenu = 'logistica';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start min-w-full">
  <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
    <section class="bg-white rounded shadow">
      <div class="p-3 border-b border-gray-200 text-sm font-semibold">
        Dashboard Logistica
      </div>
      <div class="iframe-shell">
        <iframe
          src="<?php echo htmlspecialchars($base . 'view/logistica/index.php?embed=1', ENT_QUOTES, 'UTF-8'); ?>"
          title="Logistica"
          class="iframe-logistica"
          loading="lazy"
          referrerpolicy="no-referrer"
        ></iframe>
      </div>
    </section>
  </div>
</main>

<style>
  .iframe-shell {
    width: 100%;
    height: calc(100vh - 140px);
  }
  .iframe-logistica {
    width: 100%;
    height: 100%;
    border: 0;
  }
  @media (max-width: 768px) {
    .iframe-shell {
      height: calc(100vh - 170px);
    }
  }
</style>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
