<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('logistica');

if (!isset($_GET['embed'])) {
    header('Location: ' . $base . 'view/logistica/integrado.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Dashboard Operativo - Gestión Logística Compipro">
    <meta name="theme-color" content="#0f172a">
    <title>Panel Operativo | Compipro</title>
    
    <link rel="icon" href="https://cdn-icons-png.flaticon.com/512/9312/9312239.png" type="image/png">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <link rel="stylesheet" href="style.css">
    
    <style>
        /* Forzar fuente Inter */
        body { font-family: 'Inter', sans-serif !important; }

        /* Loader de Carga Inicial */
        #pageLoader {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: #f1f5f9; z-index: 9999;
            display: flex; justify-content: center; align-items: center; flex-direction: column;
            transition: opacity 0.5s ease, visibility 0.5s;
        }
        .spinner {
            width: 40px; height: 40px; border: 4px solid #cbd5e1;
            border-top: 4px solid #3b82f6; border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        
        /* Botón Refrescar Manual */
        .refresh-btn {
            background: none; border: none; color: #64748b;
            cursor: pointer; font-size: 16px; transition: color 0.2s, transform 0.2s;
            margin-left: 10px; padding: 5px; display: inline-flex;
        }
        .refresh-btn:hover { color: #3b82f6; }
        .refresh-btn i.spinning { animation: spin 1s linear infinite; }
    </style>
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2.2.0"></script>
</head>
<body>
    
    <div id="pageLoader">
        <div class="spinner"></div>
        <p style="margin-top: 15px; color: #64748b; font-size: 14px; font-weight: 600;">Cargando Dashboard Compipro...</p>
    </div>

    <audio id="alertSound" src="assets/audio/notificacion.mp3" preload="auto"></audio>

    <div class="app-container">
        
        <aside class="sidebar">
            <div class="logo">
                <i class="fa-solid fa-layer-group"></i>
                <span>PANEL GESTIÓN</span>
            </div>
            <nav class="nav-menu">
                <a href="#" class="nav-item active">
                    <i class="fa-solid fa-chart-line"></i>
                    <span>DASHBOARD</span>
                </a>
                <a href="https://www.notion.so/rea-Log-stica-Panel-Operativo-2a7fbb813b4c806a83dcf22553964654" target="_blank" class="nav-item">
                    <i class="fa-solid fa-external-link-alt"></i>
                    <span>Notion General</span>
                </a>
            </nav>
            <div style="margin-top: auto; padding: 20px; text-align: center; color: #94a3b8; font-size: 11px;">
                <p>Compipro S.A.C. &copy; <?php echo date('Y'); ?></p>
            </div>
        </aside>

        <main class="main-content">
            
            <header class="top-header">
                <div class="header-title" style="display: flex; align-items: center;">
                    <button class="menu-toggle" id="sidebarToggle" aria-label="Abrir menú lateral">
                        <i class="fa-solid fa-bars"></i>
                    </button>
                    <div>
                        <h1>Panel Operativo</h1>
                        <div style="display: flex; align-items: center; gap: 8px;">
                            <?php
                                // Configuración Zona Horaria
                                date_default_timezone_set('America/Lima');
                            ?>
                            <span class="date" id="currentDate"><?php echo date('d/m/Y'); ?></span>
                            <button class="refresh-btn" id="manualRefreshBtn" onclick="manualRefresh()" title="Forzar actualización">
                                <i class="fa-solid fa-arrows-rotate"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="user-profile">
                    <div class="notifications" id="notificationIcon" onclick="openModal()" title="Ver alertas">
                        <i class="fa-regular fa-bell"></i>
                        <span class="badge" id="alertBadge" style="display: none;">!</span>
                    </div>
                    <div class="avatar" title="Usuario Compipro">AD</div>
                </div>
            </header>

            <div class="dashboard-content">
                
                <div class="kpi-grid">
                    <div class="kpi-card blue">
                        <div class="kpi-header"><span>Proyectos Activos</span><i class="fa-solid fa-briefcase"></i></div>
                        <div class="kpi-value" id="kpi-activos">--</div>
                        <div class="kpi-trend">En curso actualmente</div>
                    </div>
                    <div class="kpi-card green">
                        <div class="kpi-header"><span>Entregados</span><i class="fa-solid fa-check-circle"></i></div>
                        <div class="kpi-value" id="kpi-entregados">--</div>
                        <div class="kpi-trend">Acumulado Mes</div>
                    </div>
                    <div class="kpi-card red">
                        <div class="kpi-header"><span>En Reproceso</span><i class="fa-solid fa-rotate-left"></i></div>
                        <div class="kpi-value" id="kpi-reprocesos">--</div>
                        <div class="kpi-trend">Proyectos devueltos</div>
                    </div>
                    <div class="kpi-card orange">
                        <div class="kpi-header"><span>Cierres Pendientes</span><i class="fa-regular fa-clock"></i></div>
                        <div class="kpi-value" id="kpi-pendientes">--</div>
                        <div class="kpi-trend">Falta documentación</div>
                    </div>
                </div>

                <div class="charts-grid">
                    
                    <div class="chart-card" id="statusCard">
                        <div class="chart-header">
                            <div><h3>Estado de Proyectos</h3><p>Distribución actual</p></div>
                            <a href="https://www.notion.so/PROYECTOS-2a7fbb813b4c816dbe61c83d87d587e6" target="_blank" class="btn-notion-small">
                                Ver detalles <i class="fa-solid fa-arrow-right-long"></i>
                            </a>
                        </div>
                        <div class="chart-container"><canvas id="statusChart"></canvas></div>
                    </div>

                    <div class="chart-card">
                        <div class="chart-header" style="flex-direction: column; align-items: flex-start; gap: 15px;">
                            
                            <div style="width: 100%; display: flex; justify-content: space-between; align-items: flex-start;">
                                <div>
                                    <?php
                                        // Mes en Español
                                        $meses = ["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"];
                                        $mesActual = $meses[date('n') - 1];
                                    ?>
                                    <h3>Avance (<?php echo $mesActual; ?>)</h3>
                                    <p>Top 5 Urgentes</p>
                                </div>
                                <a href="https://www.notion.so/2a7fbb813b4c8155a36ecb9cb4a94e78" target="_blank" class="btn-notion-small icon-only" title="Ver tabla completa">
                                    <i class="fa-solid fa-arrow-up-right-from-square"></i>
                                </a>
                            </div>

                            <div class="control-panel-container">
                                
                                <div class="control-group">
                                    <label for="weekFilter">Periodo:</label>
                                    <select id="weekFilter" onchange="enableApplyButton()" class="control-input">
                                        <option value="week1">Semana 1</option>
                                        <option value="week2">Semana 2</option>
                                        <option value="week3">Semana 3</option>
                                        <option value="week4">Semana 4</option>
                                        <option value="week5">Semana 5</option> 
                                    </select>
                                </div>

                                <div class="control-group">
                                    <label for="cleanVal">Eliminar completados tras:</label>
                                    <div class="input-row">
                                        <input type="number" id="cleanVal" value="24" min="1" oninput="enableApplyButton()" class="control-input small">
                                        <select id="cleanUnit" onchange="enableApplyButton()" class="control-input medium">
                                            <option value="minutes">Minutos</option>
                                            <option value="hours" selected>Horas</option>
                                            <option value="days">Días</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="control-actions">
                                    <button id="applyBtn" class="btn-apply" onclick="applyCleanupSettings()">
                                        <i class="fa-solid fa-check"></i> Aplicar Regla
                                    </button>

                                    <button id="toggleBtn" class="btn-toggle" onclick="toggleHiddenProjects()" style="display: none;">
                                        <i class="fa-regular fa-eye"></i> Ver Eliminados
                                    </button>

                                    <button id="cancelBtn" class="btn-cancel" onclick="cancelCleanupSettings()" style="display: none;">
                                        <i class="fa-solid fa-ban"></i> Cancelar
                                    </button>
                                </div>
                            </div>
                            
                            <div class="status-message-bar">
                                <span id="cleanupStatusText">
                                    <i class="fa-solid fa-power-off" style="color:#94a3b8"></i> Auto-eliminación desactivada.
                                </span>
                                <span id="refreshTimer" class="timer-badge" style="display:none;">
                                    <i class="fa-regular fa-clock" style="margin-right:6px;"></i>
                                    Próx. validación: --:--:--
                                </span>
                            </div>

                        </div>
                        <div class="chart-container"><canvas id="progressChart"></canvas></div>
                    </div>

                    <div class="chart-card">
                        <div class="chart-header">
                            <div><h3>Criticidad</h3><p>Nivel de urgencia</p></div>
                            <a href="https://www.notion.so/2a7fbb813b4c81cf97fbee560735628b" target="_blank" class="btn-notion-small">
                                Ver detalles <i class="fa-solid fa-arrow-right-long"></i>
                            </a>
                        </div>
                        <div class="chart-container"><canvas id="criticalityChart"></canvas></div>
                    </div>

                    <div class="chart-card">
                        <div class="chart-header">
                            <div><h3>Cierres</h3><p>Calidad de entrega</p></div>
                            <a href="https://www.notion.so/2a7fbb813b4c8155a36ecb9cb4a94e78" target="_blank" class="btn-notion-small">
                                Ver detalles <i class="fa-solid fa-arrow-right-long"></i>
                            </a>
                        </div>
                        <div class="chart-container"><canvas id="closingChart"></canvas></div>
                    </div>

                </div>
            </div>
        </main>

        <div id="alertModal" class="modal">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="modal-title">
                        <i class="fa-solid fa-triangle-exclamation" style="font-size: 20px;"></i>
                        <h2>¡Alerta de Reproceso!</h2>
                    </div>
                    <button class="close-btn" onclick="closeModal()" aria-label="Cerrar modal">&times;</button>
                </div>
                <div class="modal-body">
                    <div class="alert-stat">
                        <i class="fa-solid fa-circle-exclamation" style="color: #ef4444; font-size: 24px;"></i>
                        <div><strong>Atención</strong><p>Proyectos devueltos requieren revisión inmediata.</p></div>
                    </div>
                    <div class="affected-projects">
                        <h4>Proyectos Afectados:</h4>
                        <ul id="reprocesoList" class="affected-projects-list">
                            </ul>
                    </div>
                    <div class="modal-actions"><button class="btn secondary" onclick="closeModal()">Entendido</button></div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="script.js"></script>
    
    <script>
        // Ocultar Loader
        window.addEventListener('load', function() {
            setTimeout(function() {
                const loader = document.getElementById('pageLoader');
                if(loader) { 
                    loader.style.opacity = '0'; 
                    loader.style.visibility = 'hidden'; 
                }
            }, 600);
        });
    </script>
</body>
</html>
