<?php
if (!isset($base)) {
    require_once __DIR__ . '/../../config/auth.php';
}

$areaActual = function_exists('getUserArea') ? (getUserArea() ?: 'General') : 'General';
$activeMenu = isset($activeMenu) ? $activeMenu : '';


// Nuevo grupo: Comercial 2.0
$menuComercial2 = [
    [ 'key' => 'empresas', 'label' => 'Empresas', 'href' => $base . 'view/empresa/index.php', 'module' => 'empresas' ],
    [ 'key' => 'contactos_empresa', 'label' => 'Contactos', 'href' => $base . 'view/contactos/index.php', 'module' => 'contactos_empresa' ],
    [ 'key' => 'requerimientos_v2', 'label' => 'RequerimientoV2', 'href' => $base . 'view/requerimiento_v2/index.php', 'module' => 'requerimientos_v2' ],
    [ 'key' => 'leads', 'label' => 'Leads', 'href' => $base . 'view/leads/index.php', 'module' => 'leads' ],
];

// Grupos de enlaces con clave de módulo para permisos
$menuClientes = [
    [ 'key' => 'clientes', 'label' => 'Listar Clientes', 'href' => $base . 'index.php', 'module' => 'clientes' ],
    [ 'key' => 'requerimientos', 'label' => 'Requerimientos por atender', 'href' => $base . 'view/requerimientos/index.php', 'module' => 'requerimientos' ],
    [ 'key' => 'cumples', 'label' => 'Cumpleanios/Aniversario Clientes', 'href' => $base . 'view/cumpleanos-aniversario/index.php', 'module' => 'cumples' ],
];

$menuProveedores = [
    [ 'key' => 'proveedores', 'label' => 'Listar Proveedores', 'href' => $base . 'view/proveedores/index.php', 'module' => 'proveedores' ],
    [ 'key' => 'provee_contacto', 'label' => 'Listar Contacto Proveedores', 'href' => $base . 'view/provee_contacto/index.php', 'module' => 'proveedor_contactos' ],
];

$menuCatalogos = [
    [ 'key' => 'catalogos', 'label' => 'Panel / Listar', 'href' => $base . 'view/catalogos/index.php', 'module' => 'catalogos' ],
];

$menuListaPrecios = [
    [ 'key' => 'lista_precios', 'label' => 'Ver Listas', 'href' => $base . 'view/lista-precios/index.php', 'module' => 'lista_precios' ],
];

$menuFeriasEventos = [
    [ 'key' => 'ferias_eventos', 'label' => 'Panel / Listar', 'href' => $base . 'view/ferias-eventos/index.php', 'module' => 'ferias_eventos' ],
];

$menuCampanas = [
    [ 'key' => 'campanas', 'label' => 'Panel / Listar', 'href' => $base . 'view/campanas/index.php', 'module' => 'campanas' ],
    [ 'key' => 'mautic_config', 'label' => 'Config Mautic', 'href' => $base . 'view/mautic/index.php', 'module' => 'campanas' ],
];

// Nuevo grupo: Logistica
$menuLogistica = [
    [ 'key' => 'logistica', 'label' => 'Panel Logistica', 'href' => $base . 'view/logistica/integrado.php', 'module' => 'logistica' ],
];

// Nuevo grupo: Productos/Categorías/Proveedor-Producto
$menuProductos = [
    [ 'key' => 'categoria', 'label' => 'Categorías', 'href' => $base . 'view/categoria/index.php', 'module' => 'categoria' ],
    [ 'key' => 'producto', 'label' => 'Productos', 'href' => $base . 'view/producto/index.php', 'module' => 'producto' ],
    [ 'key' => 'provider_product', 'label' => 'Productos/Proveedores', 'href' => $base . 'view/provider_product/index.php', 'module' => 'provider_product' ],
];

// Nuevo grupo: Usuarios
$menuUsuarios = [
    [ 'key' => 'usuarios_nuevo', 'label' => 'Crear Nuevo Usuario', 'href' => $base . 'view/usuarios/crear.php', 'module' => 'usuarios' ],
    [ 'key' => 'usuarios', 'label' => 'Listar Usuarios', 'href' => $base . 'view/usuarios/listar.php', 'module' => 'usuarios' ],
];

// Mapa de visibilidad por area (vacio => visible para todos)
$visibilidad = [
    // 'usuarios' => ['Programacion', 'Administracion'],
    // 'catalogos' => ['Administracion', 'Logistica', 'Programacion'],
];

$permitido = function(array $item) use ($visibilidad, $areaActual): bool {
    $key = $item['key'];
    if (isset($visibilidad[$key]) && !empty($visibilidad[$key]) && !in_array($areaActual, $visibilidad[$key], true)) {
        return false;
    }
    if (function_exists('hasModuleAccess') && !empty($item['module'])) {
        return hasModuleAccess($item['module']);
    }
    return true;
};

$visibleMenu = function(array $menu) use ($permitido): bool {
    foreach ($menu as $item) {
        if ($permitido($item)) {
            return true;
        }
    }
    return false;
};
?>

<div class="w-[50px] bg-primary flex items-center pt-4 fixed left-0 min-h-screen z-40 flex-col -mt-2">
    <div class="w-[50px] bg-primary flex flex-col items-center pt-4 barra">
        <br><br>
        <?php if ($visibleMenu($menuComercial2)): ?>
        <!-- Grupo Comercial 2.0 -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-diagram-project text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Comercial 2.0</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuComercial2 as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($visibleMenu($menuLogistica)): ?>
        <!-- Grupo Logistica -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-warehouse text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Logistica</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuLogistica as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if ($visibleMenu($menuClientes)): ?>
        <!-- Grupo Clientes -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-users text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Clientes</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuClientes as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($visibleMenu($menuProveedores)): ?>
        <!-- Grupo Proveedores -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-truck text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Proveedores</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuProveedores as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($visibleMenu($menuCatalogos)): ?>
        <!-- Grupo Catalogos -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-book text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Catalogos</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuCatalogos as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($visibleMenu($menuListaPrecios)): ?>
        <!-- Grupo Lista de Precios -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-tags text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Lista de Precios</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuListaPrecios as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($visibleMenu($menuFeriasEventos)): ?>
        <!-- Grupo Ferias y Eventos -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-calendar-days text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Ferias y Eventos</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuFeriasEventos as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($visibleMenu($menuCampanas)): ?>
        <!-- Grupo Campanas -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-bullhorn text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Campanas</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuCampanas as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>       

        <?php if ($visibleMenu($menuUsuarios)): ?>
        <!-- Grupo Usuarios -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-user-shield text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Usuarios</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuUsuarios as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($visibleMenu($menuProductos)): ?>
        <!-- Grupo Productos -->
        <div class="group relative grupo-icono">
            <div class="p-3 cursor-pointer group-hover:bg-gray-800">
                <i class="fas fa-boxes text-white text-xl"></i>
            </div>
            <div class="absolute left-full top-0 ml-0 w-64 bg-gray-800 rounded-tr-lg rounded-br-lg shadow-lg p-4 hidden group-hover:block z-50">
                <p class="font-semibold mb-2 text-white">Productos</p>
                <ul class="space-y-2 text-sm">
                    <?php foreach ($menuProductos as $item): if (!$permitido($item)) continue; ?>
                        <li onclick="window.location.href = '<?php echo $item['href']; ?>'"
                            class="hover:bg-gray-700 text-white p-2 rounded cursor-pointer <?php echo $activeMenu === $item['key'] ? 'bg-gray-700' : '' ?>">
                            <?php echo htmlspecialchars($item['label'], ENT_QUOTES, 'UTF-8'); ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
