<?php
// Layout start: head + header + sidebar
// Requiere que $base esté disponible desde config/auth.php y que la sesión esté iniciada
if (!isset($base)) {
    require_once __DIR__ . '/../../config/auth.php';
}

$pageTitle = isset($pageTitle) ? $pageTitle : 'CRM Compipro';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="<?php echo $base ?>icons/favicon.png" type="image/x-icon">
    <title><?php echo htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8'); ?></title>

    <link href="<?php echo $base ?>assets/css/static/font-awesome.6.5.0.all.min.css" rel="stylesheet">
    <link href="<?php echo $base ?>assets/css/static/flatpickr.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo $base ?>styles.css">
    <link rel="stylesheet" href="<?php echo $base ?>assets/css/output.css">
    <link rel="stylesheet" href="<?php echo $base ?>assets/css/styles.css">
    <link rel="stylesheet" href="https://unpkg.com/tabulator-tables@5.6.2/dist/css/tabulator.min.css">

    <script>
        // Asegura que 'base' esté disponible antes que cualquier script
        var base = '<?php echo $base ?>';
        <?php
        if (session_status() === PHP_SESSION_ACTIVE && isset($_SESSION['usuario'])) {
            $currentUser = json_encode(["user" => $_SESSION['usuario'], "area" => $_SESSION['area'] ?? null]);
            echo "var currentUser = $currentUser;";
        }
        ?>
    </script>
    <!-- Librería flatpickr requerida por varios módulos -->
    <script src="<?php echo $base ?>assets/js/static/flatpickr.min.js"></script>
    <script src="https://unpkg.com/tabulator-tables@5.6.2/dist/js/tabulator.min.js"></script>
    <script src="<?php echo $base ?>assets/js/static/sweetalert2.all.min.js" defer></script>
    <?php if (function_exists('isWebsocketArea') && isWebsocketArea()): ?>
        <script src="https://cdn.socket.io/4.7.5/socket.io.min.js"></script>
        <script src="<?php echo $base ?>config/conexion.js"></script>
    <?php endif; ?>
</head>
<body class="bg-lightAlt min-h-screen flex flex-col overflow-x-hidden items-start">
    <div id="preloader" class="fixed inset-0 z-50 bg-white/80 flex items-center justify-center hidden">
        <div class="w-12 h-12 border-4 border-blue-500 border-t-transparent rounded-full animate-spin"></div>
    </div>

    <?php include __DIR__ . '/header.php'; ?>
    <div class="h-[50px]"></div>
    <?php include __DIR__ . '/sidebar.php'; ?>
