<?php
if (!isset($base)) {
    require_once __DIR__ . '/../../config/auth.php';
}
$pageTitle = isset($pageTitle) ? $pageTitle : 'CRM Compipro';
$userNombre = trim($_SESSION['nombres'] ?? '');
$userApellidos = trim($_SESSION['apellidos'] ?? '');
$userLogin = trim($_SESSION['usuario'] ?? '');
$displayName = trim($userNombre . ' ' . $userApellidos);
if ($displayName === '') {
    $displayName = $userLogin !== '' ? $userLogin : 'Usuario';
}
$parts = preg_split('/\s+/', $displayName);
$first = $parts[0] ?? '';
$second = $parts[1] ?? '';
$initials = strtoupper(substr($first !== '' ? $first : 'U', 0, 1));
$initials .= strtoupper(substr($second !== '' ? $second : $initials, 0, 1));
?>
<header class="fixed top-0 left-0 right-0 bg-primary text-white md:py-3 px-6 shadow-md z-50">
    <div class="flex items-center justify-between">
        <div class="flex items-center space-x-3">
            <img src="<?php echo $base ?>icons/logo.png" alt="Logo" class="h-8 w-auto object-contain hidden sm:block">
            <h1 class="text-xl md:text-2xl font-bold">
                <?php echo htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8'); ?>
            </h1>
        </div>
        <div class="relative">
            <button id="userMenuBtn" class="flex items-center gap-2 px-2 py-1 rounded-full hover:bg-white/10 transition">
                <span class="h-8 w-8 rounded-full bg-white/20 flex items-center justify-center text-sm font-semibold">
                    <?php echo htmlspecialchars($initials, ENT_QUOTES, 'UTF-8'); ?>
                </span>
                <span class="hidden sm:inline-block text-sm font-semibold">
                    <?php echo htmlspecialchars($displayName, ENT_QUOTES, 'UTF-8'); ?>
                </span>
                <i class="fas fa-chevron-down text-xs opacity-80"></i>
            </button>
            <div id="userMenu" class="hidden absolute right-0 mt-2 w-44 bg-white text-gray-800 rounded-md shadow-lg overflow-hidden">
                <a href="<?php echo $base ?>logout.php" class="block px-4 py-2 text-sm hover:bg-gray-100">
                    <i class="fas fa-sign-out-alt mr-2"></i> Cerrar Sesion
                </a>
            </div>
        </div>
    </div>
</header>
<script>
  (function () {
    const btn = document.getElementById("userMenuBtn");
    const menu = document.getElementById("userMenu");
    if (!btn || !menu) return;
    btn.addEventListener("click", function (e) {
      e.stopPropagation();
      menu.classList.toggle("hidden");
    });
    document.addEventListener("click", function (e) {
      if (!menu.classList.contains("hidden")) {
        menu.classList.add("hidden");
      }
    });
  })();
</script>
