<?php
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('ferias_eventos');
date_default_timezone_set('America/Lima');

$ferias = [
    [
        'nombre' => 'FERIA UPCYCLING 2025',
        'registros' => 'https://compipro.net/marketing/formulario/ferias/ver_registros.php',
        'formulario' => 'https://compipro.net/marketing/formulario/ferias/index.php'
    ],
    [
        'nombre' => 'FERIA RESMINE 2025',
        'registros' => 'https://compipro.net/marketing/formulario/feria/ver_registros.php',
        'formulario' => 'https://compipro.net/marketing/formulario/feria/index.php'
    ],
    [
        'nombre' => 'FERIA CCL 2025',
        'registros' => 'https://compipro.net/marketing/formulario/ferias_CCL_2025/ver_registros.php',
        'formulario' => 'https://compipro.net/marketing/formulario/ferias_CCL_2025/index.php'
    ],
    [
        'nombre' => 'FERIA PERUMIN',
        'registros' => 'https://compipro.net/marketing/formulario/perumin/ver_registros.php',
        'formulario' => 'https://compipro.net/marketing/formulario/perumin/index.php'
    ],
];

$pageTitle = 'Ferias y Eventos';
$activeMenu = 'ferias_eventos';

include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen w-full py-6 pr-4 md:pr-6">
  <div class="ferias-wrapper w-full max-w-5xl mx-auto px-4">
    <h2 class="text-2xl font-bold text-gray-800 mb-4 flex items-center gap-2">
      <i class="fas fa-calendar-days text-primary"></i> Ferias y Eventos
    </h2>
    <table class="ferias bg-white rounded-lg shadow">
      <thead>
        <tr>
          <th>Nombre</th>
          <th>Registros</th>
          <th>Formulario</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($ferias as $feria): ?>
          <tr>
            <td><?php echo htmlspecialchars($feria['nombre'], ENT_QUOTES, 'UTF-8'); ?></td>
            <td><a class="text-blue-600 underline" href="<?php echo htmlspecialchars($feria['registros'], ENT_QUOTES, 'UTF-8'); ?>" target="_blank" rel="noopener">Ver registros</a></td>
            <td><a class="text-blue-600 underline" href="<?php echo htmlspecialchars($feria['formulario'], ENT_QUOTES, 'UTF-8'); ?>" target="_blank" rel="noopener">Formulario</a></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</main>

<style>
.ferias-wrapper { max-width: 1100px; }
table.ferias { width: 100%; border-collapse: collapse; }
table.ferias th, table.ferias td { padding: .75rem 1rem; border-bottom: 1px solid #e5e7eb; }
table.ferias th { background: var(--color-primary, #e5910a); color: white; text-transform: uppercase; font-size: .8rem; letter-spacing: .05em; }
table.ferias tr:hover { background: #f9fafb; }
</style>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
