<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('empresas');

$pageTitle = 'MÓDULO EMPRESAS';
$activeMenu = 'empresas';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full">
  <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
    <section class="bg-white p-4 rounded shadow">
      <div class="flex gap-2 items-end mb-4 flex-wrap">
        <div>
          <label class="text-xs">Buscar</label>
          <div class="flex items-center gap-2">
            <select id="emp-search-by" class="border text-xs border-gray-300 rounded px-2 py-1 h-8">
              <option value="todos">Todos</option>
              <option value="id">ID</option>
              <option value="ruc">RUC</option>
              <option value="razon_social">Razón Social</option>
              <option value="nombre_comercial">Nombre Comercial</option>
              <option value="email">Email</option>
              <option value="telefono">Teléfono</option>
              <option value="rubro">Rubro</option>
            </select>
            <div class="flex items-stretch">
              <input id="emp-q" class="border px-3 text-sm h-8 rounded-l-md rounded-r-none w-72 md:w-96 lg:w-[32rem]" placeholder="Escribe y presiona Enter">
              <button id="btnClearSearch" title="Limpiar búsqueda" class="inline-flex items-center justify-center px-3 h-8 bg-gray-200 text-gray-700 rounded-r-md rounded-l-none hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-300 border border-gray-300 border-l-0">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>
        </div>
        <button id="btnBuscar" class="bg-primary text-white px-3 py-1 rounded text-sm">Buscar</button>
        <button id="btnNuevo" class="ml-auto bg-green-600 text-white px-3 py-1 rounded text-sm">
          <i class="fas fa-plus"></i> Nueva Empresa
        </button>
      </div>

      <div class="flex items-center gap-3 text-xs text-gray-600 mb-2 pl-2">
        <label id="totalEmpresas">Total: 0</label>
        <label class="text-xs">Por página</label>
        <select id="pageSize" class="border text-xs border-gray-300 rounded px-2 py-1">
          <option value="10">10</option>
          <option value="20">20</option>
          <option value="25" selected>25</option>
          <option value="50">50</option>
          <option value="100">100</option>
        </select>
      </div>

      <div id="tabla-scroll" class="w-full max-h-[70vh] overflow-auto bg-white rounded pr-6 md:pr-8">
        <table class="tabla-mini table-sticky-first table-comfy table-spacious min-w-[1000px] w-full text-left text-xs" id="tablaEmpresas">
          <thead class="sticky top-0 z-20 bg-gray-800 text-white">
            <tr>
              <th class="px-2 py-1 text-xs">ID</th>
              <th class="px-2 py-1 text-xs">RUC</th>
              <th class="px-2 py-1 text-xs">Nombre Comercial</th>
              <th class="px-2 py-1 text-xs">Razón Social</th>
              <th class="px-2 py-1 text-xs">Rubro</th>
              <th class="px-2 py-1 text-xs">Teléfono</th>
              <th class="px-2 py-1 text-xs">Email</th>
              <th class="px-2 py-1 text-xs">Acciones</th>
            </tr>
          </thead>
          <tbody id="tbodyEmpresas" class="bg-white divide-y divide-gray-200">
            <tr>
              <td class="px-2 py-1 text-gray-500 text-xs" colspan="8">Sin datos</td>
            </tr>
          </tbody>
        </table>
      </div>

      <div id="pagination-container" class="p-2 sticky bottom-0 bg-white"></div>
    </section>
  </div>
</main>

<div id="empresaModal" class="fixed inset-0 bg-black/50 z-50 hidden items-center justify-center">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-5xl p-5 max-h-[85vh] overflow-y-auto">
    <div class="flex items-center justify-between mb-3">
      <h2 id="empresaModalTitle" class="text-lg font-semibold">Nueva Empresa</h2>
      <button id="btnCloseEmpresaModal" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="grid grid-cols-5 gap-4">
      <div class="col-span-4">
        <div class="flex gap-2 mb-3">
          <button data-tab="empresa" class="emp-tab-btn px-3 py-1 bg-primary text-white rounded text-xs">Datos de Empresa</button>
          <button data-tab="direccion" class="emp-tab-btn px-3 py-1 bg-gray-200 rounded text-xs hover:bg-gray-300">Dirección</button>
          <button data-tab="otros" class="emp-tab-btn px-3 py-1 bg-gray-200 rounded text-xs hover:bg-gray-300">Otros Datos</button>
        </div>

        <div id="tab-empresa" class="grid grid-cols-1 md:grid-cols-4 gap-3">
          <div class="md:col-span-1">
            <label class="text-xs">ID (solo lectura)</label>
            <input id="e_id" class="border px-2 py-1 w-full bg-gray-100" readonly>
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">RUC *</label>
            <input id="e_ruc" class="border px-2 py-1 w-full" placeholder="RUC">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Razón Social *</label>
            <input id="e_razon_social" class="border px-2 py-1 w-full" placeholder="Razón Social">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Nombre Comercial</label>
            <input id="e_nombre_comercial" class="border px-2 py-1 w-full" placeholder="Nombre Comercial">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Rubro</label>
            <input id="e_rubro" class="border px-2 py-1 w-full" placeholder="Rubro">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Tipo de Empresa</label>
            <select id="e_tipo_empresa" class="border px-2 py-1 w-full">
              <option value="">Seleccionar</option>
              <option value="PROSPECTO">PROSPECTO</option>
              <option value="FRECUENTE">FRECUENTE</option>
              <option value="TERCERISTA">TERCERISTA</option>
              <option value="POTENCIAL">POTENCIAL</option>
              <option value="OTRO">OTRO</option>
            </select>
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Número de Trabajadores</label>
            <input id="e_n_trabajadores" type="number" min="0" class="border px-2 py-1 w-full" placeholder="0">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Estado Contribuyente (SUNAT)</label>
            <select id="e_estado_contribuyente" class="border px-2 py-1 w-full">
              <option value="">Seleccionar</option>
              <option value="ACTIVO">ACTIVO</option>
              <option value="BAJA TEMPORAL">BAJA TEMPORAL</option>
              <option value="SUSPENDIDO">SUSPENDIDO</option>
            </select>
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Condición Contribuyente (SUNAT)</label>
            <select id="e_condicion_contribuyente" class="border px-2 py-1 w-full">
              <option value="">Seleccionar</option>
              <option value="HABIDO">HABIDO</option>
              <option value="NO HABIDO">NO HABIDO</option>
            </select>
          </div>
        </div>

        <div id="tab-direccion" class="grid grid-cols-1 md:grid-cols-4 gap-3 hidden">
          <div class="md:col-span-1">
            <label class="text-xs">País</label>
            <input id="e_country_id" class="border px-2 py-1 w-full" placeholder="PE">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Departamento</label>
            <input id="e_department_id" class="border px-2 py-1 w-full" placeholder="Departamento">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Provincia</label>
            <input id="e_province_id" class="border px-2 py-1 w-full" placeholder="Provincia">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Distrito</label>
            <input id="e_district_id" class="border px-2 py-1 w-full" placeholder="Distrito">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Dirección</label>
            <input id="e_direccion" class="border px-2 py-1 w-full" placeholder="Dirección">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Referencia</label>
            <input id="e_referencia" class="border px-2 py-1 w-full" placeholder="Referencia">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Teléfono</label>
            <input id="e_telefono" class="border px-2 py-1 w-full" placeholder="Teléfono">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Celular</label>
            <input id="e_celular" class="border px-2 py-1 w-full" placeholder="Celular">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Email</label>
            <input id="e_email" type="email" class="border px-2 py-1 w-full" placeholder="Email">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Website</label>
            <input id="e_website" class="border px-2 py-1 w-full" placeholder="https://">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Origen</label>
            <select id="e_origen" class="border px-2 py-1 w-full">
              <option value="">Seleccionar</option>
              <option value="WHATSAPP">WhatsApp</option>
              <option value="CORREO">Correo</option>
              <option value="FERIA">Feria</option>
              <option value="LLAMADA">Llamada</option>
              <option value="REFERIDO">Referido</option>
              <option value="OTRO">Otro</option>
            </select>
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Aniversario</label>
            <input id="e_aniversario" type="date" class="border px-2 py-1 w-full">
          </div>
        </div>

        <div id="tab-otros" class="grid grid-cols-1 md:grid-cols-2 gap-3 hidden">
          <div>
            <label class="text-xs">Política de Pago</label>
            <textarea id="e_politica_pago" class="border px-2 py-1 w-full" rows="3"></textarea>
          </div>
          <div>
            <label class="text-xs">Procedimiento Especial</label>
            <textarea id="e_procedimiento_especial" class="border px-2 py-1 w-full" rows="3"></textarea>
          </div>
          <div>
            <label class="text-xs">Frecuencia de Compra</label>
            <input id="e_frecuencia_compra" class="border px-2 py-1 w-full" placeholder="Semanal/Mensual/Trimestral">
          </div>
          <div>
            <label class="text-xs">Adicionales</label>
            <textarea id="e_adicionales" class="border px-2 py-1 w-full" rows="3"></textarea>
          </div>
          <div class="md:col-span-2 flex items-center gap-2">
            <input id="e_trabaja_con_proveedores" type="checkbox" class="h-4 w-4">
            <label class="text-xs">Trabaja con Proveedores</label>
          </div>
        </div>
      </div>

      <div class="col-span-1">
        <div class="border border-gray-200 rounded p-3 bg-gray-50">
          <div class="text-xs font-semibold mb-2">Bitácora de cambios</div>
          <div id="empresaHistorialContainer" class="text-xs text-gray-600 space-y-2 max-h-72 overflow-auto"></div>
        </div>
      </div>
    </div>

    <div class="flex items-center justify-end gap-2 mt-4">
      <button id="btnCancelarEmpresa" class="px-3 py-1 rounded text-sm bg-gray-200 hover:bg-gray-300">Cancelar</button>
      <button id="btnGuardarEmpresa" class="px-3 py-1 rounded text-sm bg-primary text-white">Guardar</button>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../components/contacto_quick_modal.php'; ?>

<script src="<?php echo $base ?>assets/js/static/sweetalert2.all.min.js" defer></script>
<script type="module">
  import { paginacion, updateRowsPerPage } from "<?php echo $base ?>assets/js/requerimientos/paginacion.js";
  window.empPaginacion = paginacion;
  window.updateEmpRowsPerPage = updateRowsPerPage;
  const sel = document.getElementById('pageSize');
  if (sel) {
    paginacion.rowsPerPage = parseInt(sel.value || '25', 10);
  }
  paginacion.renderFunction = () => { window.reloadEmpresasTable?.(); };
  window.dispatchEvent(new Event('empresas-paginacion-ready'));
</script>
<script src="<?php echo $base ?>assets/js/empresa/index.js" defer></script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
