<?php
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('cumples');
date_default_timezone_set('America/Lima');

$pageTitle = 'Cumpleanios y Aniversarios';
$activeMenu = 'cumples';

include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen w-full py-6 pr-4 md:pr-6">
  <div class="max-w-6xl mx-auto px-4">
    <h2 class="text-2xl font-bold text-gray-800 mb-4 flex items-center gap-2">
      <i class="fas fa-birthday-cake text-primary"></i> Cumpleaños / Aniversarios de Clientes
    </h2>

    <div class="bg-white rounded-lg shadow p-4 mb-4 flex flex-wrap items-center gap-3 text-sm">
      <div class="flex items-center gap-2">
        <label for="filtro-mes" class="font-semibold">Mes:</label>
        <select id="filtro-mes" class="border border-gray-300 rounded px-2 py-1">
          <option value="0">Todos</option>
          <option value="1">Enero</option>
          <option value="2">Febrero</option>
          <option value="3">Marzo</option>
          <option value="4">Abril</option>
          <option value="5">Mayo</option>
          <option value="6">Junio</option>
          <option value="7">Julio</option>
          <option value="8">Agosto</option>
          <option value="9">Septiembre</option>
          <option value="10">Octubre</option>
          <option value="11">Noviembre</option>
          <option value="12">Diciembre</option>
        </select>
      </div>
      <div class="flex items-center gap-2">
        <label for="buscar" class="font-semibold">Buscar:</label>
        <input id="buscar" type="text" placeholder="Razón, contacto, cargo..." class="border border-gray-300 rounded px-2 py-1 w-56">
      </div>
      <div class="flex items-center gap-2">
        <label for="page-size" class="font-semibold">Por página:</label>
        <select id="page-size" class="border border-gray-300 rounded px-2 py-1">
          <option value="10">10</option>
          <option value="25" selected>25</option>
          <option value="50">50</option>
          <option value="100">100</option>
        </select>
      </div>
    </div>

    <?php include __DIR__ . '/tabla.php'; ?>
    <div id="paginacion" class="flex items-center gap-2 justify-end text-xs mt-2"></div>
    <?php include __DIR__ . '/modal.php'; ?>
  </div>
</main>

<script type="module" src="<?php echo $base ?>assets/js/cumpleanos-aniversario/page.js"></script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
