<div id="contactoModal" class="fixed inset-0 bg-black/50 z-50 hidden items-center justify-center">
  <div class="bg-white rounded-lg shadow-lg w-full max-w-6xl p-5 max-h-[90vh] overflow-y-auto">
    <div class="flex items-center justify-between mb-3">
      <h2 id="contactoModalTitle" class="text-lg font-semibold">Nuevo Contacto</h2>
      <button id="btnCloseModal" class="text-gray-500 hover:text-gray-700"><i class="fas fa-times"></i></button>
    </div>

    <div class="grid grid-cols-5 gap-4">
      <div class="col-span-4">
        <div class="md:col-span-1">
          <label class="text-xs">ID Contacto</label>
          <input id="m_id" class="border px-2 py-1 w-full bg-gray-100" readonly>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
          <div class="md:col-span-2">
            <div class="flex items-center justify-between">
              <label class="text-xs">Empresa *</label>
              <button id="btnNuevaEmpresa" type="button" class="text-[11px] bg-gray-200 px-2 py-1 rounded hover:bg-gray-300">+ Nuevo</button>
            </div>
            <div class="relative">
              <input id="m_empresa_input" class="border px-2 py-1 w-full" placeholder="Busca y selecciona empresa" autocomplete="off">
              <input id="m_empresa_id" type="hidden">
              <div id="empresaDropdown" class="absolute left-0 right-0 mt-1 bg-white border border-gray-200 rounded shadow-lg max-h-60 overflow-auto hidden z-50"></div>
            </div>
            <p class="text-[11px] text-gray-500 mt-1">Escribe para filtrar</p>
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Nombres *</label>
            <input id="m_nombres" class="border px-2 py-1 w-full" placeholder="Nombres">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Apellidos</label>
            <input id="m_apellidos" class="border px-2 py-1 w-full" placeholder="Apellidos">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Cargo</label>
            <input id="m_cargo" class="border px-2 py-1 w-full" placeholder="Cargo">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">N° Identidad (DNI)</label>
            <input id="m_num_doc" class="border px-2 py-1 w-full" placeholder="DNI">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Tipo contacto</label>
            <input id="m_tipo_contacto" class="border px-2 py-1 w-full" placeholder="Tipo contacto">
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Origen</label>
            <select id="m_origen" class="border px-2 py-1 w-full">
              <option value="" selected>Seleccione</option>
              <option value="WHATSAPP">WhatsApp</option>
              <option value="CORREO">Correo</option>
              <option value="FERIA">Feria</option>
              <option value="LLAMADA">Llamada</option>
              <option value="REFERIDO">Referido</option>
              <option value="OTRO">Otro</option>
            </select>
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Fecha cumpleanos</label>
            <input id="m_fecha_cumpleanos" type="date" class="border px-2 py-1 w-full">
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Celular principal</label>
            <div class="flex items-stretch gap-0">
              <select id="m_celular_tipo" class="border border-gray-300 px-2 py-1 rounded-l-md text-sm focus:outline-none">
                <option value="movil" selected>Movil</option>
                <option value="trabajo">Trabajo</option>
                <option value="casa">Casa</option>
                <option value="otro">Otro</option>
              </select>
              <input id="m_celular" class="border border-l-0 border-gray-300 px-2 py-1 w-full focus:outline-none" placeholder="Celular">
            </div>
          </div>
          <div class="md:col-span-1">
            <label class="text-xs">Telefono fijo</label>
            <div class="flex items-stretch gap-0">
              <select id="m_telefono_fijo_tipo" class="border border-gray-300 px-2 py-1 rounded-l-md text-sm focus:outline-none">
                <option value="fijo" selected>Fijo</option>
                <option value="trabajo">Trabajo</option>
                <option value="casa">Casa</option>
                <option value="otro">Otro</option>
              </select>
              <input id="m_telefono_fijo" class="border border-l-0 border-gray-300 px-2 py-1 w-full focus:outline-none" placeholder="Telefono fijo">
            </div>
          </div>
          <div class="md:col-span-2">
            <label class="text-xs">Email principal</label>
            <div class="flex items-stretch gap-0">
              <select id="m_email_tipo" class="border border-gray-300 px-2 py-1 rounded-l-md text-sm focus:outline-none">
                <option value="trabajo">Trabajo</option>
                <option value="personal">Personal</option>
                <option value="casa">Casa</option>
                <option value="otro">Otro</option>
              </select>
              <input id="m_email" type="email" class="border border-l-0 border-gray-300 px-2 py-1 w-full focus:outline-none" placeholder="Email principal">
            </div>
          </div>
          <div class="md:col-span-4">
            <label class="text-xs">Direccion</label>
            <input id="m_direccion" class="border px-2 py-1 w-full" placeholder="Direccion">
          </div>
          <div class="md:col-span-4">
            <label class="text-xs">Referencia</label>
            <input id="m_referencia" class="border px-2 py-1 w-full" placeholder="Referencia">
          </div>
        </div>

        <div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
          <div>
            <div class="flex items-center justify-between mb-2">
              <label class="text-xs font-semibold">Teléfonos adicionales</label>
              <button id="btnAddTelefono" type="button" class="text-xs bg-blue-600 text-white px-2 py-1 rounded">Agregar</button>
            </div>
            <div id="telefonosContainer" class="space-y-2"></div>
          </div>
          <div>
            <div class="flex items-center justify-between mb-2">
              <label class="text-xs font-semibold">Emails adicionales (tipo / email)</label>
              <button id="btnAddEmail" type="button" class="text-xs bg-blue-600 text-white px-2 py-1 rounded">Agregar</button>
            </div>
            <div id="emailsContainer" class="space-y-2"></div>
          </div>
        </div>
      </div>

      <div class="col-span-1">
        <div class="border border-gray-200 rounded p-3 bg-gray-50">
          <div class="text-xs font-semibold mb-2">Bitácora de cambios</div>
          <div id="historialContainer" class="text-xs text-gray-600 space-y-2 max-h-72 overflow-auto"></div>
        </div>
      </div>
    </div>

    <div class="flex items-center justify-end gap-2 mt-4">
      <button id="btnCancelar" class="px-3 py-1 rounded text-sm bg-gray-200 hover:bg-gray-300">Cancelar</button>
      <button id="btnGuardar" class="px-3 py-1 rounded text-sm bg-primary text-white">Guardar</button>
    </div>
  </div>

  <?php include __DIR__ . '/../components/empresa_quick_modal.php'; ?>
</div>
