<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('contactos_empresa');

$pageTitle = 'MODULO CONTACTOS';
$activeMenu = 'contactos_empresa';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full">
  <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
    <section class="bg-white p-4 rounded shadow">
      <div class="flex gap-2 items-end mb-4 flex-wrap">
        <div>
          <label class="text-xs">Buscar</label>
          <div class="flex items-center gap-2">
            <select id="ct-search-by" class="border text-xs border-gray-300 rounded px-2 py-1 h-8">
              <option value="todos">Todos</option>
              <option value="id">ID</option>
              <option value="empresa">Empresa</option>
              <option value="nombres">Nombres</option>
              <option value="apellidos">Apellidos</option>
              <option value="cargo">Cargo</option>
              <option value="celular">Celular</option>
              <option value="email">Email</option>
            </select>
            <div class="flex items-stretch">
              <input id="ct-q" class="border px-3 text-sm h-8 rounded-l-md rounded-r-none w-72 md:w-96 lg:w-[32rem]" placeholder="Escribe y presiona Enter">
              <button id="btnClearSearch" title="Limpiar búsqueda" class="inline-flex items-center justify-center px-3 h-8 bg-gray-200 text-gray-700 rounded-r-md rounded-l-none hover:bg-gray-300 focus:outline-none focus:ring-2 focus:ring-gray-300 border border-gray-300 border-l-0">
                <i class="fas fa-times"></i>
              </button>
            </div>
          </div>
        </div>
        <button id="btnBuscar" class="bg-primary text-white px-3 py-1 rounded text-sm">Buscar</button>
        <button id="btnNuevo" class="ml-auto bg-green-600 text-white px-3 py-1 rounded text-sm">
          <i class="fas fa-plus"></i> Nuevo Contacto
        </button>
      </div>

      <div class="flex items-center gap-3 text-xs text-gray-600 mb-2 pl-2 w-full justify-between">
        <div class="flex items-center gap-3">
          <label id="totalContactos">Total: 0</label>
          <label class="text-xs">Por pagina</label>
          <select id="pageSize" class="border text-xs border-gray-300 rounded px-2 py-1">
            <option value="10">10</option>
            <option value="20">20</option>
            <option value="25" selected>25</option>
            <option value="50">50</option>
            <option value="100">100</option>
          </select>
        </div>
        <div class="relative group pb-2">
          <button id="btn-columns" class="bg-slate-700 text-black px-3 py-1 rounded text-sm hover:bg-slate-800">
            Mostrar/Ocultar columnas
          </button>
          <div class="absolute right-0 top-full mt-0 w-56 bg-white border border-gray-200 rounded shadow-lg hidden group-hover:block group-focus-within:block z-50">
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="ct-col-toggle" data-col="num_doc">
              Nro Identidad
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="ct-col-toggle" data-col="tipo_contacto">
              Tipo contacto
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="ct-col-toggle" data-col="direccion">
              Direccion
            </label>
            <label class="flex items-center gap-2 px-3 py-2 text-xs hover:bg-gray-50">
              <input type="checkbox" class="ct-col-toggle" data-col="referencia">
              Referencia
            </label>
          </div>
        </div>
      </div>

      <div id="tabla-scroll" class="w-full max-h-[70vh] overflow-auto bg-white rounded pr-6 md:pr-8">
        <table class="tabla-mini table-sticky-first table-comfy table-spacious min-w-[1400px] w-full text-left text-xs" id="tablaContactos">
          <thead class="sticky top-0 z-20 bg-gray-800 text-white">
            <tr>
              <th class="px-2 py-1 text-xs">ID</th>
              <th class="px-2 py-1 text-xs">Empresa</th>
              <th class="px-2 py-1 text-xs">Nombres</th>
              <th class="px-2 py-1 text-xs">Apellidos</th>
              <th class="px-2 py-1 text-xs" data-col="num_doc">Nro Identidad</th>
              <th class="px-2 py-1 text-xs">Cargo</th>
              <th class="px-2 py-1 text-xs">Origen</th>
              <th class="px-2 py-1 text-xs">Celular</th>
              <th class="px-2 py-1 text-xs">Email</th>
              <th class="px-2 py-1 text-xs" data-col="tipo_contacto">Tipo contacto</th>
              <th class="px-2 py-1 text-xs" data-col="direccion">Direccion</th>
              <th class="px-2 py-1 text-xs" data-col="referencia">Referencia</th>
              <th class="px-2 py-1 text-xs">Actualizado</th>
              <th class="px-2 py-1 text-xs">Usuario</th>
              <th class="px-2 py-1 text-xs">Acciones</th>
            </tr>
          </thead>
          <tbody id="tbodyContactos" class="bg-white divide-y divide-gray-200">
            <tr>
              <td class="px-2 py-1 text-gray-500 text-xs" colspan="15">Sin datos</td>
            </tr>
          </tbody>
        </table>
      </div>

      <div id="pagination-container" class="p-2 sticky bottom-0 bg-white"></div>
    </section>
  </div>
</main>

<?php include __DIR__ . '/modal.php'; ?>

</div>

<script src="<?php echo $base ?>assets/js/static/sweetalert2.all.min.js" defer></script>
<script type="module">
  import { paginacion, updateRowsPerPage } from "<?php echo $base ?>assets/js/requerimientos/paginacion.js";
  window.ctPaginacion = paginacion;
  window.updateCtRowsPerPage = updateRowsPerPage;
  const sel = document.getElementById('pageSize');
  if (sel) {
    paginacion.rowsPerPage = parseInt(sel.value || '25', 10);
  }
  paginacion.renderFunction = () => { window.reloadContactosTable?.(); };
  window.dispatchEvent(new Event('contactos-paginacion-ready'));
</script>
<script src="<?php echo $base ?>assets/js/contactos/index.js" defer></script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
