<?php
// Filtros mínimos para listar clientes, con los IDs que consumen los JS
?>
<div class="relative z-30 px-1 ml-12 mr-4 md:mr-6">
  <div class="sticky-x top-auto left-[51px] right-0 mb-4">
    <div class="bg-white p-3 rounded-lg shadow-md mb-2">
      <div class="w-full">
        <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-3">
          <div class="flex flex-col space-y-2">
            <div>
              <label class="block text-xs font-medium text-gray-700 mb-0.5">Buscar Por:</label>
              <div class="flex">
                <select id="filtro-por" class="w-1/2 border text-xs border-gray-300 rounded-l px-1 py-1 focus:outline-none focus:ring-1 focus:ring-primary">
                  <option class="text-xs" value="todos">Todos</option>
                  <option class="text-xs" value="num-cliente">ID / Numero cliente</option>
                  <option class="text-xs" value="empresa">Razón Comercial "Empresa"</option>
                  <option class="text-xs" value="razon_social">Razón Social</option>
                  <option class="text-xs" value="nombres">Nombres</option>
                  <option class="text-xs" value="apellidos">Apellidos</option>
                  <option class="text-xs" value="usuarios">Usuarios</option>
                  <option class="text-xs" value="rubro">Rubro</option>
                  <option class="text-xs" value="ruc">RUC</option>
                  <option class="text-xs" value="telefono">Teléfono</option>
                  <option class="text-xs" value="celular">Celular</option>
                  <option class="text-xs" value="direccion_oficina">Dirección Oficina</option>
                  <option class="text-xs" value="direccion_empresa">Dirección Empresa</option>
                  <option class="text-xs" value="emails">Emails</option>
                  <option class="text-xs" value="web">Web</option>
                </select>
                <div class="relative w-full">
                  <input id="texto-buscar" type="text" placeholder="Buscar" class="w-full border text-xs border-gray-300 border-l-0 rounded-r px-2 py-1 focus:outline-none focus:ring-1 focus:ring-primary">
                </div>
              </div>
            </div>
            
            <button id="btnAgregarCliente" class="bg-primary hover:bg-primary/80 text-white text-xs font-bold py-1 px-3 rounded-full flex items-center justify-center mt-2 whitespace-nowrap transition-all duration-300 shadow-md">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
              </svg>
              AGREGAR CLIENTE
            </button>
          </div>

          <div class="flex flex-col space-y-2 h-full">
            <div>
              <label class="block text-xs font-medium text-gray-700">Rango de Fechas:</label>
              <input type="text" id="fecha-rango" class="w-full border text-xs border-gray-300 rounded px-2 py-1 focus:outline-none focus:ring-1 focus:ring-primary" placeholder="Seleccione fecha" />
              <div class="flex items-center space-x-4 mt-1 text-xs text-gray-600">
                <span id="fecha-desde"></span>
                <span id="fecha-hasta"></span>
              </div>
            </div>
            <div class="status">
              <label class="block text-xs font-medium text-gray-700 mb-0.5">Status Atención:</label>
              <select id="filtro-status" name="prioridad" class="w-full border border-gray-300 text-xs rounded px-2 py-1 focus:outline-none focus:ring-1 focus:ring-primary">
                <option class="text-xs" value="">Todos</option>
                <option class="text-xs" value="Contacto Inicial">Contacto Inicial</option>
                <option class="text-xs" value="Retomar Contacto">Retomar Contacto</option>
                <option class="text-xs" value="Pendientes por Cotizar">Pendientes por Cotizar</option>
                <option class="text-xs" value="Cotizado">Cotizado</option>
                <option class="text-xs" value="Venta Realizado">Venta Realizado</option>
                <option class="text-xs" value="Venta No Realizado">Venta No Realizado</option>
                <option class="text-xs" value="Prod. Entregado">Prod. Entregado</option>
              </select>
            </div>
            <button id="btnRegistrosEliminados" class="bg-gray-700 hover:bg-gray-600 text-white text-xs font-bold py-1 px-3 rounded-full flex items-center justify-center mt-2 whitespace-nowrap transition-all duration-300 shadow-md">
              <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
              </svg>
              REGISTROS ELIMINADOS
            </button>
          </div>

          <div class="flex flex-col space-y-2">
            <div>
              <label class="block text-xs font-medium text-gray-700 mb-0.5">Filtrar por fecha:</label>
              <div class="flex items-center space-x-3 text-xs text-gray-700">
                <label class="inline-flex items-center">
                  <input type="radio" name="tipoFecha" value="aviso" class="mr-1">
                  <span>Fecha de Aviso</span>
                </label>
                <label class="inline-flex items-center">
                  <input type="radio" name="tipoFecha" value="atencion" class="mr-1">
                  <span>Fecha de Atención</span>
                </label>
              </div>
            </div>

            <div>
              <label class="block text-xs font-medium text-gray-700">Tipo de Cliente:</label>
              <select id="filtro-tipo-cliente" class="w-full border border-gray-300 text-xs rounded px-2 py-1 focus:outline-none focus:ring-1 focus:ring-primary">
                <option class="text-xs" value="">Todos</option>
                <option class="text-xs" value="-">Ninguno</option>
                <option class="text-xs" value="Potencial">Potenciales</option>
                <option class="text-xs" value="Frecuentes">Frecuentes</option>
                <option class="text-xs" value="Ocasionales">Ocasionales</option>
                <option class="text-xs" value="Tercerizadores">Tercerizadores</option>
                <option class="text-xs" value="Prospecto">Prospecto</option>
                <option class="text-xs" value="No Potencial">No Potencial</option>
                <option class="text-xs" value="Mal Cliente">Mal Cliente</option>
              </select>
            </div>

            <div>
              <label class="block text-xs font-medium text-gray-700">Origen:</label>
              <select id="filtro-origen" class="w-full border border-gray-300 text-xs rounded px-2 py-1 focus:outline-none focus:ring-1 focus:ring-primary">
                <option class="text-xs" value="">Todos</option>
              </select>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</div>
