<?php
// Renderiza solo el contenido dentro de <main> ... </main> del archivo legacy.
// Busca primero en esta carpeta y, si es un proxy, usa la copia en view/clientes/.

$candidatos = [
    __DIR__ . '/_index_legacy.php',
];

$ruta = null;
foreach ($candidatos as $p) {
    if (!is_file($p)) continue;
    $content = @file_get_contents($p);
    if ($content !== false && (stripos($content, '<main') !== false || stripos($content, '<body') !== false)) {
        $ruta = $p;
        break;
    }
}

if ($ruta === null) {
    echo '<div class="p-4 text-red-600">No se encontró el contenido legacy para Clientes.</div>';
    return;
}

$html = @file_get_contents($ruta);
if ($html === false || $html === '') {
    echo '<div class="p-4 text-red-600">No se pudo leer el contenido legacy.</div>';
    return;
}

// Extraer bloque principal
if (preg_match('/<main\b[^>]*>.*?<\/main>/is', $html, $m)) {
    echo $m[0];
    return;
}

// Si no hubiese etiqueta <main>, intentar imprimir el cuerpo parcial seguro
if (preg_match('/<body\b[^>]*>(.*)<\/body>/is', $html, $mb)) {
    echo '<div class="p-2">' . $mb[1] . '</div>';
    return;
}

echo '<div class="p-4 text-yellow-700">No se encontró la sección principal (main) en el legacy.</div>';
