<?php
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('catalogos');
date_default_timezone_set('America/Lima');

$catalogos = [
    [ 'nombre' => 'Catalogo General 2025', 'url' => 'https://generalcatalogue2025.eu/compipro' ],
    [ 'nombre' => 'Catalogo Compipro PDF', 'url' => 'https://compipro.net/documentos/catalogo-compipro/Catalogo_Compipro.pdf' ],
    [ 'nombre' => 'Catalogo Upcycling',     'url' => 'https://compipro.net/Catalogo/CAT%C3%81LOGO_UPCYCLING.pdf' ],
];

$pageTitle = 'Panel de Catalogos';
$activeMenu = 'catalogos';

include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen w-full py-6 pr-4 md:pr-6">
  <div class="catalogos-wrapper w-full max-w-5xl mx-auto px-4">
    <h2 class="text-2xl font-bold text-gray-800 mb-4 flex items-center gap-2">
      <i class="fas fa-boxes-stacked text-primary"></i> Catálogos disponibles
    </h2>
    <p class="text-sm text-gray-600 mb-6">Haz clic para abrir el catálogo o copia el enlace para compartir.</p>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <?php foreach ($catalogos as $cat): ?>
        <div class="bg-white shadow rounded-lg p-4 flex items-center justify-between">
          <div>
            <p class="text-base font-semibold text-gray-800"><?php echo htmlspecialchars($cat['nombre'], ENT_QUOTES, 'UTF-8'); ?></p>
            <p class="text-xs text-gray-500 break-all"><?php echo htmlspecialchars($cat['url'], ENT_QUOTES, 'UTF-8'); ?></p>
          </div>
          <div class="flex flex-col gap-2">
            <button class="bg-primary text-white px-3 py-1 rounded text-xs hover:bg-primary/90"
              onclick="verCatalogo('<?php echo htmlspecialchars($cat['url'], ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($cat['nombre'], ENT_QUOTES, 'UTF-8'); ?>')">
              Ver
            </button>
            <button class="bg-gray-200 text-gray-700 px-3 py-1 rounded text-xs hover:bg-gray-300"
              onclick="copiarLink('<?php echo htmlspecialchars($cat['url'], ENT_QUOTES, 'UTF-8'); ?>')">
              Copiar enlace
            </button>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
</main>

<!-- Modal -->
<div id="modalBackdrop" class="modal-backdrop">
  <div class="modal-shell relative">
    <div class="modal-head">
      <div class="modal-title" id="modalTitulo">Vista de Catálogo</div>
      <div class="modal-actions">
        <a id="modalLinkExterno" href="#" target="_blank" class="bg-white text-primary px-3 py-2 text-xs font-semibold">Abrir en nueva pestaña</a>
        <button id="modalCerrar" class="bg-primary text-white px-3 py-2 text-xs font-semibold">Cerrar</button>
      </div>
    </div>
    <div class="modal-loader" id="modalLoader">
      <div class="loader"></div>
    </div>
    <iframe id="modalIframe" src="about:blank" class="w-full flex-1" allowfullscreen></iframe>
  </div>
</div>

<script>
  function copiarLink(url) {
    navigator.clipboard.writeText(url).then(() => {
      Swal.fire({ icon: 'success', title: 'Enlace copiado', text: url, timer: 1800, showConfirmButton: false });
    }).catch(() => {
      Swal.fire({ icon: 'error', title: 'No se pudo copiar', timer: 1500, showConfirmButton: false });
    });
  }

  const backdrop  = document.getElementById('modalBackdrop');
  const iframe    = document.getElementById('modalIframe');
  const titulo    = document.getElementById('modalTitulo');
  const linkExt   = document.getElementById('modalLinkExterno');
  const btnCerrar = document.getElementById('modalCerrar');
  const loader    = document.getElementById('modalLoader');

  function verCatalogo(url, nombre) {
    titulo.textContent = nombre || 'Vista de Catálogo';
    linkExt.href = url; linkExt.classList.remove('hidden');

    document.body.classList.add('modal-open');
    backdrop.style.display = 'flex';
    loader.style.display = 'flex';
    try { iframe.src = 'about:blank'; } catch(e){}
    setTimeout(() => { iframe.src = url; }, 0);

    clearTimeout(iframe.__timeout);
    iframe.__timeout = setTimeout(() => { loader.style.display = 'none'; }, 7000);
  }

  function cerrarModal() {
    try { iframe.src = 'about:blank'; } catch(e){}
    backdrop.style.display = 'none';
    document.body.classList.remove('modal-open');
    loader.style.display = 'none';
    clearTimeout(iframe.__timeout);
  }

  btnCerrar.addEventListener('click', cerrarModal);
  document.addEventListener('keydown', (e) => { if (e.key === 'Escape') cerrarModal(); });
  backdrop.addEventListener('click', (e) => { if (e.target === backdrop) cerrarModal(); });
  iframe.addEventListener('load', () => { loader.style.display = 'none'; });
</script>

<?php include __DIR__ . '/../layout/layout_end.php'; ?>
