<?php
require_once __DIR__ . '/../../config/auth.php';
requireModuleAccess('campanas');

$pageTitle = 'MODULO CAMPANAS';
$activeMenu = 'campanas';
include __DIR__ . '/../layout/layout_start.php';
?>

<main class="min-h-screen py-4 grid grid-cols-1 items-start border min-w-full flex flex-col">
    <div class="relative z-30 px-1 ml-12 mr-4 md:mr-6 flex-1 min-h-0">
        <section class="bg-white p-4 rounded shadow flex flex-col h-full min-h-0">
            <div class="flex gap-6 items-stretch w-full flex-nowrap min-w-0 overflow-hidden flex-1 min-h-0">
                <aside class="panel w-[35%] flex-none min-w-0 h-full" aria-label="Navegacion de campanas">
                    <div class="panel-header">
                        <div class="title"><span class="dot"></span>Campanas</div>
                        <div class="flex gap-2">
                            <a href="../../controller/campanas/CampanasExcelController.php?action=exportar" class="btn mini ghost">Exportar</a>
                            <button class="btn mini" id="btnCreateRoot">Crear +</button>
                        </div>
                    </div>
                    <div class="search-wrap">
                        <input class="search" id="treeSearch" placeholder="Buscar campana o asunto" />
                    </div>
                    <div class="tree" id="tree"></div>
                </aside>

                <div class="content w-[65%] flex-none min-w-0 overflow-hidden h-full" id="contactos-panel">
                    <div class="content-top">
                        <div>
                            <div class="crumbs" id="crumbs">Selecciona una campana</div>
                            <h1 class="h1" id="h1">Gestion de campanas</h1>
                            <div class="meta" id="meta"></div>
                            <div class="meta-status" id="meta-estado"></div>
                        </div>
                        <div class="kpi-row" id="kpis">
                            <div class="kpi">
                                <div class="k">Contactos directos</div>
                                <div class="v" id="kpiDirect">--</div>
                            </div>
                            <div class="kpi">
                                <div class="k">Contactos totales</div>
                                <div class="v" id="kpiTotal">--</div>
                            </div>
                            <div class="kpi">
                                <div class="k">Envios</div>
                                <div class="v" id="kpiSends">--</div>
                            </div>
                            <div class="kpi">
                                <div class="k">Abrieron</div>
                                <div class="v" id="kpiOpened">--</div>
                            </div>
                            <div class="kpi">
                                <div class="k">Con clic</div>
                                <div class="v" id="kpiClickers">--</div>
                            </div>
                            <div class="kpi">
                                <div class="k">Pendientes</div>
                                <div class="v" id="kpiPending">--</div>
                            </div>
                        </div>
                    </div>
                    <div class="content-top">
                        <p id="meta-asunto">
                            <span id="meta-asunto-text"></span>
                        </p>
                    </div>
                    <div class="tabs" id="tabs">
                        <button class="tab active" data-tab="resumen">Resumen</button>
                        <button class="tab" data-tab="contactos">Contactos</button>
                        <button class="tab" data-tab="pendientes">Pendientes</button>
                    </div>
                    <section class="view" id="view">
                        <div class="card" id="panel-help">
                            <h3 class="text-lg font-bold text-gray-800 mb-2">Como usar esta vista</h3>
                            <p class="muted mb-0">
                                1) Elige una campana en el arbol. <br>
                                2) Revisa sus contactos en la pestana de Contactos. <br>
                                3) Usa KPIs para un resumen rapido.
                            </p>
                        </div>
                        <div class="card hidden" id="panel-contactos">
                            <div class="flex flex-wrap items-center justify-between gap-2 mb-3">
                                <h3 class="text-lg font-bold text-gray-800 flex items-center">
                                    <i class="fas fa-users text-orange-500 mr-2"></i>
                                    Contactos de la campana
                                </h3>
                                <div class="flex items-center gap-2 text-xs text-gray-600">
                                    <label>Por pagina</label>
                                    <select id="contactos-per-page" class="border rounded px-2 py-1 text-xs">
                                        <option value="10">10</option>
                                        <option value="25" selected>25</option>
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                    </select>
                                </div>
                            </div>
                            <div id="contactos-empty" class="text-sm text-gray-500 italic">
                                Selecciona una campana para ver sus contactos.
                            </div>
                            <div id="contactos-table" class="overflow-x-auto overflow-y-auto max-h-[58vh] max-w-full w-full hidden">
                                <table class="tabla-mini table-sticky-first table-comfy table-spacious whitespace-nowrap w-full text-xs">
                                    <thead class="sticky top-0 z-20 bg-gray-800 text-white whitespace-nowrap">
                                        <tr>
                                            <th class="px-2 py-1 text-left">Empresa</th>
                                            <th class="px-2 py-1 text-left">Nro Trabajadores</th>
                                            <th class="px-2 py-1 text-left">Nombre</th>
                                            <th class="px-2 py-1 text-left">Cargo</th>
                                            <th class="px-2 py-1 text-left">Email</th>
                                            <th class="px-2 py-1 text-left">Telefono</th>
                                            <th class="px-2 py-1 text-left">Celular</th>
                                            <th class="px-2 py-1 text-center sortable cursor-pointer" data-sort="open_flag">
                                                Abierto <span class="sort-indicator" data-indicator="open_flag">↕</span>
                                            </th>
                                            <th class="px-2 py-1 text-center sortable cursor-pointer" data-sort="clicks">
                                                Clicks <span class="sort-indicator" data-indicator="clicks">↕</span>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody id="contactos-body"></tbody>
                                </table>
                            </div>
                            <div id="contactos-pagination" class="p-2 sticky bottom-0 bg-white hidden"></div>
                        </div>
                        <div class="card hidden" id="panel-pendientes">
                            <div class="flex flex-wrap items-center justify-between gap-2 mb-3">
                                <h3 class="text-lg font-bold text-gray-800 flex items-center">
                                    <i class="fas fa-exclamation-triangle text-orange-500 mr-2"></i>
                                    Pendientes de registro
                                </h3>
                                <div class="flex items-center gap-2 text-xs text-gray-600">
                                    <label>Por pagina</label>
                                    <select id="pendientes-per-page" class="border rounded px-2 py-1 text-xs">
                                        <option value="10">10</option>
                                        <option value="25" selected>25</option>
                                        <option value="50">50</option>
                                        <option value="100">100</option>
                                    </select>
                                </div>
                            </div>
                            <div id="pendientes-empty" class="text-sm text-gray-500 italic">
                                Selecciona una campana para ver los pendientes.
                            </div>
                            <div id="pendientes-table" class="overflow-x-auto overflow-y-auto max-h-[58vh] max-w-full w-full hidden">
                                <table class="tabla-mini table-sticky-first table-comfy table-spacious whitespace-nowrap w-full text-xs">
                                    <thead class="sticky top-0 z-20 bg-gray-800 text-white whitespace-nowrap">
                                        <tr>
                                            <th class="px-2 py-1 text-left">Email</th>
                                            <th class="px-2 py-1 text-left">Lead ID</th>
                                            <th class="px-2 py-1 text-left">Primera vez</th>
                                            <th class="px-2 py-1 text-left">Ultima vez</th>
                                            <th class="px-2 py-1 text-left">Fuente</th>
                                        </tr>
                                    </thead>
                                    <tbody id="pendientes-body"></tbody>
                                </table>
                            </div>
                            <div id="pendientes-pagination" class="p-2 sticky bottom-0 bg-white hidden"></div>
                        </div>
                    </section>
                </div>
            </div>
        </section>
    </div>
</main>

<?php include __DIR__ . '/modal.php'; ?>
<script src="<?php echo $base ?>assets/js/campanas/index.js"></script>
<?php include __DIR__ . '/../layout/layout_end.php'; ?>
