const express = require("express");
const http = require("http");
const { Server } = require("socket.io");

const app = express();
const server = http.createServer(app);
const io = new Server(server, {
  path: "/ws/socket.io",
  cors: {
    origin: "*",
    methods: ["GET", "POST"],
  },
});

const PORT = process.env.PORT || 8080;

io.on("connection", (socket) => {
  console.log('🔌 Cliente conectado');
  socket.on('identificar', (data) => {
    const area = data.tipo || 'General';
    const nombre = data.usuario || 'Invitado';

    console.log(`🧑 Usuario conectado: ${nombre} (área: ${area})`);

    socket.join(area);
    socket.data.area = area;
  });
  socket.on('disconnect', () => {
    console.log('🚫 Cliente desconectado');
  });
});

server.listen(PORT, () => {
  console.log(`Servidor Node.js corriendo en http://localhost:${PORT}`);
});
