<?php

class RequerimientoInteraccionModel
{
    private PDO $conn;
    private string $table = 'requerimiento_interaccion';

    public function __construct(PDO $db)
    {
        $this->conn = $db;
    }

    public function add(array $data): int
    {
        $requerimientoId = (int)($data['requerimiento_id'] ?? 0);
        if ($requerimientoId <= 0) {
            throw new InvalidArgumentException('requerimiento_id es obligatorio');
        }

        $stmt = $this->conn->prepare(
            "INSERT INTO {$this->table}
                (requerimiento_id, canal, resumen, requiere_seguimiento, proximo_seguimiento, user_id, created_at, updated_at)
             VALUES
                (:requerimiento_id, :canal, :resumen, :requiere_seguimiento, :proximo_seguimiento, :user_id, :created_at, :updated_at)"
        );

        $now = date('Y-m-d H:i:s');
        $stmt->execute([
            ':requerimiento_id'   => $requerimientoId,
            ':canal'              => $data['canal'] ?? null,
            ':resumen'            => $data['resumen'] ?? null,
            ':requiere_seguimiento' => !empty($data['requiere_seguimiento']) ? 1 : 0,
            ':proximo_seguimiento' => $data['proximo_seguimiento'] ?? null,
            ':user_id'            => $data['user_id'] ?? null,
            ':created_at'         => $now,
            ':updated_at'         => $now,
        ]);

        return (int)$this->conn->lastInsertId();
    }

    public function listByRequerimiento(int $requerimientoId): array
    {
        $stmt = $this->conn->prepare(
            "SELECT i.*, u.usuario, u.nombres, u.apellidos
             FROM {$this->table} i
             LEFT JOIN usuarios u ON u.idusuario = i.user_id
             WHERE i.requerimiento_id = :id
             ORDER BY i.created_at DESC, i.id DESC"
        );
        $stmt->execute([':id' => $requerimientoId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
