<?php

class RequerimientoCotizacionModel
{
    private PDO $conn;
    private string $table = 'requerimiento_cotizacion';

    public function __construct(PDO $db)
    {
        $this->conn = $db;
    }

    public function add(array $data): int
    {
        $requerimientoId = (int)($data['requerimiento_id'] ?? 0);
        if ($requerimientoId <= 0) {
            throw new InvalidArgumentException('requerimiento_id es obligatorio');
        }

        $stmt = $this->conn->prepare(
            "INSERT INTO {$this->table}
                (requerimiento_id, archivo, monto, observaciones, user_id, created_at, updated_at)
             VALUES
                (:requerimiento_id, :archivo, :monto, :observaciones, :user_id, :created_at, :updated_at)"
        );

        $now = date('Y-m-d H:i:s');
        $stmt->execute([
            ':requerimiento_id' => $requerimientoId,
            ':archivo'          => $data['archivo'] ?? null,
            ':monto'            => $data['monto'] ?? null,
            ':observaciones'    => $data['observaciones'] ?? null,
            ':user_id'          => $data['user_id'] ?? null,
            ':created_at'       => $now,
            ':updated_at'       => $now,
        ]);

        return (int)$this->conn->lastInsertId();
    }

    public function listByRequerimiento(int $requerimientoId): array
    {
        $stmt = $this->conn->prepare(
            "SELECT c.*, u.usuario, u.nombres, u.apellidos
             FROM {$this->table} c
             LEFT JOIN usuarios u ON u.idusuario = c.user_id
             WHERE c.requerimiento_id = :id
             ORDER BY c.created_at DESC, c.id DESC"
        );
        $stmt->execute([':id' => $requerimientoId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
