<?php

class ProviderProductModel
{
    private PDO $conn;
    private string $table = 'provider_product';

    public function __construct(PDO $db)
    {
        $this->conn = $db;
    }

    public function listByModel(int $prodmodel_id): array
    {
        $sql = "SELECT pp.*, p.razon_social, p.razon_comercial
                FROM {$this->table} pp
                INNER JOIN proveedores p ON pp.provider_id = p.idprovee
                WHERE pp.prodmodel_id = :pid";
        $stmt = $this->conn->prepare($sql);
        $stmt->bindValue(':pid', $prodmodel_id, PDO::PARAM_INT);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getByProviderAndModel(int $provider_id, int $prodmodel_id): ?array
    {
        $stmt = $this->conn->prepare("SELECT * FROM {$this->table} WHERE provider_id = :pr AND prodmodel_id = :pm LIMIT 1");
        $stmt->bindValue(':pr', $provider_id, PDO::PARAM_INT);
        $stmt->bindValue(':pm', $prodmodel_id, PDO::PARAM_INT);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row ?: null;
    }

    public function create(array $data): int
    {
        $required = ['provider_id', 'prodmodel_id'];
        foreach ($required as $r) {
            if (!isset($data[$r]) || (int)$data[$r] <= 0) {
                throw new InvalidArgumentException('Falta ' . $r . ' en la oferta del proveedor.');
            }
        }

        $columns = [
            'provider_id',
            'prodmodel_id',
            'provider_sku',
            'price_unit',
            'price_total',
            'lead_time_days',
            'provider_detail',
            'provider_specs',
            'quote_date',
            'validity_days',
            'status',
        ];

        $fields = [];
        $placeholders = [];
        $params = [];

        foreach ($columns as $c) {
            if (array_key_exists($c, $data)) {
                $fields[] = $c;
                $placeholders[] = ':' . $c;
                $params[':' . $c] = $data[$c];
            }
        }

        if (!isset($data['status']) || $data['status'] === '') {
            $fields[] = 'status';
            $placeholders[] = ':status';
            $params[':status'] = 1;
        }

        $sql = 'INSERT INTO ' . $this->table . ' (' . implode(',', $fields) . ') VALUES (' . implode(',', $placeholders) . ')';
        $stmt = $this->conn->prepare($sql);
        foreach ($params as $k => $v) {
            $stmt->bindValue($k, $v);
        }
        $stmt->execute();
        return (int)$this->conn->lastInsertId();
    }

    public function updateByProviderAndModel(int $provider_id, int $prodmodel_id, array $data): bool
    {
        $columns = [
            'provider_sku',
            'price_unit',
            'price_total',
            'lead_time_days',
            'provider_detail',
            'provider_specs',
            'quote_date',
            'validity_days',
            'status',
        ];
        $sets = [];
        $params = [
            ':pr' => $provider_id,
            ':pm' => $prodmodel_id,
        ];

        foreach ($columns as $c) {
            if (array_key_exists($c, $data)) {
                $sets[] = $c . ' = :' . $c;
                $params[':' . $c] = $data[$c];
            }
        }

        if (empty($sets)) {
            return false;
        }

        $sql = 'UPDATE ' . $this->table . ' SET ' . implode(',', $sets) . ' WHERE provider_id = :pr AND prodmodel_id = :pm';
        $stmt = $this->conn->prepare($sql);
        foreach ($params as $k => $v) {
            $stmt->bindValue($k, $v);
        }
        return $stmt->execute();
    }
}

