<?php
require_once __DIR__ . '/../config/database.php';

class Campanas
{
    private $conn;

    public function __construct()
    {
        $this->conn = (new Database())->getConnection();
    }

    public function obtenerTodas()
    {
        $sql = "SELECT * FROM campanas ORDER BY id DESC";
        $stmt = $this->conn->prepare($sql);
        $stmt->execute();
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function crear($data)
    {

        $sql = "INSERT INTO campanas 
                (nombre_campana, asunto, contacto_nombre, contacto_apellido, contacto_correo, fecha_inicio, fecha_fin)
                VALUES 
                (:nombre_campana, :asunto, :contacto_nombre, :contacto_apellido, :contacto_correo, :fecha_inicio, :fecha_fin)";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindParam(':nombre_campana', $data['nombre_campana']);
        $stmt->bindParam(':asunto', $data['asunto']);
        $stmt->bindParam(':contacto_nombre', $data['contacto_nombre']);
        $stmt->bindParam(':contacto_apellido', $data['contacto_apellido']);
        $stmt->bindParam(':contacto_correo', $data['contacto_correo']);
        $stmt->bindParam(':fecha_inicio', $data['fecha_inicio']);
        $stmt->bindParam(':fecha_fin', $data['fecha_fin']);
        return $stmt->execute();
    }

    public function obtenerPorId($id)
    {
        $sql = "SELECT * FROM campanas WHERE id = :id LIMIT 1";
        $stmt = $this->conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function actualizar($id, $data)
    {

        $sql = "UPDATE campanas SET 
                nombre_campana = :nombre_campana,
                asunto = :asunto,
                contacto_nombre = :contacto_nombre,
                contacto_apellido = :contacto_apellido,
                contacto_correo = :contacto_correo,
                fecha_inicio = :fecha_inicio,
                fecha_fin = :fecha_fin
                WHERE id = :id";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindParam(':nombre_campana', $data['nombre_campana']);
        $stmt->bindParam(':asunto', $data['asunto']);
        $stmt->bindParam(':contacto_nombre', $data['contacto_nombre']);
        $stmt->bindParam(':contacto_apellido', $data['contacto_apellido']);
        $stmt->bindParam(':contacto_correo', $data['contacto_correo']);
        $stmt->bindParam(':fecha_inicio', $data['fecha_inicio']);
        $stmt->bindParam(':fecha_fin', $data['fecha_fin']);
        $stmt->bindParam(':id', $id);

        return $stmt->execute();
    }

    public function eliminar($id)
    {
        $sql = "DELETE FROM campanas WHERE id = :id";
        $stmt = $this->conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        return $stmt->execute();
    }
    public function incrementarRegistro($id)
    {
        $sql = "UPDATE campanas SET registro = registro + 1 WHERE id = :id";
        $stmt = $this->conn->prepare($sql);
        $stmt->bindParam(':id', $id);
        return $stmt->execute();
    }
    public function crearDesdeExcel($data)
    {
        $sql = "INSERT INTO campanas
            (nombre_campana, asunto, contacto_nombre, contacto_apellido, contacto_correo, fecha_inicio, fecha_fin, registro)
            VALUES (:nombre, :asunto, :nombre_c, :apellido, :correo, :inicio, :fin, :registro)";

        $stmt = $this->conn->prepare($sql);

        $stmt->bindParam(':nombre', $data['nombre_campana']);
        $stmt->bindParam(':asunto', $data['asunto']);
        $stmt->bindParam(':nombre_c', $data['contacto_nombre']);
        $stmt->bindParam(':apellido', $data['contacto_apellido']);
        $stmt->bindParam(':correo', $data['contacto_correo']);
        $stmt->bindParam(':inicio', $data['fecha_inicio']);
        $stmt->bindParam(':fin', $data['fecha_fin']);
        $stmt->bindParam(':registro', $data['registro']);

        $stmt->execute();

        return $this->conn->lastInsertId();
    }
    public function obtenerIdPorNombre($nombre)
    {
        $sql = "SELECT id FROM campanas WHERE nombre_campana = :nombre LIMIT 1";
        $stmt = $this->conn->prepare($sql);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->execute();
        return $stmt->fetchColumn();
    }

    public function existePorNombre($nombre)
    {
        $sql = "SELECT id FROM campanas WHERE nombre_campana = :nombre LIMIT 1";
        $stmt = $this->conn->prepare($sql);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->execute();
        return $stmt->fetchColumn();
    }
}
