<?php

class HistorialStatusModel
{
    private PDO $conn;
    private string $table = 'historial_status';

    public function __construct(PDO $db)
    {
        $this->conn = $db;
    }

    public function listByContacto(int $contactoId): array
    {
        $stmt = $this->conn->prepare(
            "SELECT h.idstatus, h.idusuario, h.fechaingreso, h.status, u.usuario, u.nombres, u.apellidos
             FROM {$this->table} h
             LEFT JOIN usuarios u ON u.idusuario = h.idusuario
             WHERE h.id_contacto_unico IS NOT NULL
               AND FIND_IN_SET(:contacto_id, REPLACE(h.id_contacto_unico, ' ', '')) > 0
             ORDER BY h.fechaingreso DESC, h.idstatus DESC"
        );
        $stmt->execute([':contacto_id' => (string)$contactoId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
