<?php

class HistoriaActividadRequerimientoModel
{
    private PDO $conn;
    private string $table = 'historia_actividad_requerimiento';

    public function __construct(PDO $db)
    {
        $this->conn = $db;
    }

    public function add(
        int $requerimientoId,
        string $tipoActividad,
        ?string $detalle = null,
        ?string $etapaAnterior = null,
        ?string $etapaNueva = null,
        ?int $usuarioId = null
    ): void {
        $stmt = $this->conn->prepare(
            "INSERT INTO {$this->table} 
                (requerimiento_id, tipo_actividad, detalle, etapa_anterior, etapa_nueva, usuario_id, created_at, updated_at)
             VALUES 
                (:requerimiento_id, :tipo_actividad, :detalle, :etapa_anterior, :etapa_nueva, :usuario_id, :created_at, :updated_at)"
        );
        $now = date('Y-m-d H:i:s');
        $stmt->execute([
            ':requerimiento_id' => $requerimientoId,
            ':tipo_actividad'   => $tipoActividad,
            ':detalle'          => $detalle,
            ':etapa_anterior'   => $etapaAnterior,
            ':etapa_nueva'      => $etapaNueva,
            ':usuario_id'       => $usuarioId,
            ':created_at'       => $now,
            ':updated_at'       => $now,
        ]);
    }

    public function listByRequerimiento(int $requerimientoId): array
    {
        $stmt = $this->conn->prepare(
            "SELECT h.*, u.usuario, u.nombres, u.apellidos
             FROM {$this->table} h
             LEFT JOIN usuarios u ON u.idusuario = h.usuario_id
             WHERE h.requerimiento_id = :id
             ORDER BY h.created_at DESC, h.id DESC"
        );
        $stmt->execute([':id' => $requerimientoId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
