<?php
class EmpresaHistorialModel
{
    private PDO $conn;
    private string $table = 'empresa_historial';

    public function __construct(PDO $db)
    {
        $this->conn = $db;
    }

    public function add(int $empresaId, int $usuarioId, string $tipo): void
    {
        $stmt = $this->conn->prepare(
            "INSERT INTO {$this->table} (empresa_id, tipo_actividad, usuario_id, fecha)
             VALUES (:empresa_id, :tipo, :usuario_id, :fecha)"
        );
        $stmt->execute([
            ':empresa_id' => $empresaId,
            ':tipo' => $tipo,
            ':usuario_id' => $usuarioId,
            ':fecha' => date('Y-m-d H:i:s'),
        ]);
    }

    public function listByEmpresa(int $empresaId): array
    {
        $stmt = $this->conn->prepare(
            "SELECT h.id, h.tipo_actividad, h.usuario_id, h.fecha,
                    u.usuario, u.nombres, u.apellidos
             FROM {$this->table} h
             LEFT JOIN usuarios u ON u.idusuario = h.usuario_id
             WHERE h.empresa_id = :empresa_id
             ORDER BY h.fecha DESC, h.id DESC"
        );
        $stmt->execute([':empresa_id' => $empresaId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
