<?php
class ContactoHistorialModel
{
    private PDO $conn;
    private string $table = 'contacto_historial';

    public function __construct(PDO $db)
    {
        $this->conn = $db;
    }

    public function add(int $contactoId, int $usuarioId, string $tipo): void
    {
        $stmt = $this->conn->prepare(
            "INSERT INTO {$this->table} (contacto_id, tipo_actividad, usuario_id, fecha)
             VALUES (:contacto_id, :tipo, :usuario_id, :fecha)"
        );
        $stmt->execute([
            ':contacto_id' => $contactoId,
            ':tipo' => $tipo,
            ':usuario_id' => $usuarioId,
            ':fecha' => date('Y-m-d H:i:s'),
        ]);
    }

    public function listByContacto(int $contactoId): array
    {
        $stmt = $this->conn->prepare(
            "SELECT h.id, h.tipo_actividad, h.usuario_id, h.fecha,
                    u.usuario, u.nombres, u.apellidos
             FROM {$this->table} h
             LEFT JOIN usuarios u ON u.idusuario = h.usuario_id
             WHERE h.contacto_id = :contacto_id
             ORDER BY h.fecha DESC, h.id DESC"
        );
        $stmt->execute([':contacto_id' => $contactoId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
}
