<?php

class Contacto {

    protected $conn;
    protected $usuario_sesion;

    public function __construct($db, $id_usuario = null) {
        $this->conn = $db;
        $this->usuario_sesion = $id_usuario;
    }

    public function listar(): array {
        return $this->conn->query("
            SELECT * FROM contactos
            ORDER BY nombres ASC
        ")->fetchAll(PDO::FETCH_ASSOC);
    }

    public function crear(array $data): bool {
        $stmt = $this->conn->prepare("
            INSERT INTO contactos (nombres, apellidos, email, telefono)
            VALUES (?, ?, ?, ?)
        ");
        return $stmt->execute([
            $data['nombres'],
            $data['apellidos'] ?? null,
            $data['email'],
            $data['telefono'] ?? null
        ]);
    }
}
