<?php

class Campania {

    protected $conn;
    protected $usuario_sesion;

    public function __construct($db, $id_usuario = null) {
        $this->conn = $db;
        $this->usuario_sesion = $id_usuario;
    }

    /* ===================== LISTAR ===================== */

    // Campañas nivel 1
    public function listarPrincipales(): array {
        return $this->conn->query("
            SELECT * FROM campanias
            WHERE parent_id IS NULL
            ORDER BY created_at DESC
        ")->fetchAll(PDO::FETCH_ASSOC);
    }

    // Subcampañas
    public function listarHijas($parentId): array {
        $stmt = $this->conn->prepare("
            SELECT * FROM campanias
            WHERE parent_id = ?
            ORDER BY created_at ASC
        ");
        $stmt->execute([$parentId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function listarTodas(): array {
        return $this->conn->query("
            SELECT c.*, mi.nombre AS instancia_nombre
            FROM campanias c
            LEFT JOIN mautic_instancias mi ON mi.id = c.mautic_instancia_id
            ORDER BY COALESCE(c.parent_id, 0) ASC, c.created_at ASC
        ")->fetchAll(PDO::FETCH_ASSOC);
    }

    /* ===================== CREAR ===================== */

    public function crear(array $data): bool {
        $stmt = $this->conn->prepare("
            INSERT INTO campanias (parent_id, titulo, asunto, fecha_inicio, fecha_fin)
            VALUES (?, ?, ?, ?, ?)
        ");
        return $stmt->execute([
            $data['parent_id'] ?? null,
            $data['titulo'],
            $data['asunto'] ?? null,
            $data['fecha_inicio'] ?? null,
            $data['fecha_fin'] ?? null
        ]);
    }

    /* ===================== ACTUALIZAR ===================== */

    public function actualizar(int $id, array $data): bool {
        $stmt = $this->conn->prepare("
            UPDATE campanias
            SET titulo = ?, asunto = ?, fecha_inicio = ?, fecha_fin = ?
            WHERE id_campania = ?
        ");
        return $stmt->execute([
            $data['titulo'],
            $data['asunto'] ?? null,
            $data['fecha_inicio'] ?? null,
            $data['fecha_fin'] ?? null,
            $id
        ]);
    }

    /* ===================== ELIMINAR ===================== */

    public function eliminar(int $id): bool {
        $stmt = $this->conn->prepare("
            DELETE FROM campanias
            WHERE id_campania = ?
        ");
        return $stmt->execute([$id]);
    }
}
