<?php
require_once __DIR__.'/config/session.php';
require_once __DIR__ . '/config/auth.php';
require_once __DIR__ . '/config/telegram.php';
require_once __DIR__ . '/config/remember.php';
require_once __DIR__ . '/config/database.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$usuario = $_SESSION['usuario'] ?? 'Desconocido';
$area = $_SESSION['area'] ?? 'Sin área';
$idusuario = $_SESSION['idusuario'] ?? 0;

$ip = $_SERVER['REMOTE_ADDR'];
$navegador = $_SERVER['HTTP_USER_AGENT'] ?? 'Desconocido';

$fecha = date("Y-m-d H:i:s");

// Ubicacion con ip-api
$geo = @json_decode(file_get_contents("https://ip-api.com/json/{$ip}"));
$ciudad = $geo->city ?? 'No detectado';
$pais = $geo->country ?? 'No detectado';

// Aviso a Telegram (datos enmascarados)
$ubicacion = trim($ciudad . ', ' . $pais, ', ');
sendTelegramEvent('Logout CRM', [
    'Usuario' => telegramMaskUser($usuario),
    'ID' => $idusuario,
    'Area' => $area,
    'IP' => $ip,
    'Ubicacion' => $ubicacion,
    'Navegador' => $navegador,
    'Fecha' => $fecha,
]);

// Limpiar token de "recordarme"
if (!empty($_COOKIE[REMEMBER_COOKIE_NAME])) {
    [$selector] = explode(':', $_COOKIE[REMEMBER_COOKIE_NAME], 2);
    try {
        $db = (new Database())->getConnection();
        rememberDeleteBySelector($db, $selector);
    } catch (Throwable $e) {
        // silencio
    }
}
rememberClearCookie();

// Cerrar sesión
session_unset();
session_destroy();

// Redirigir
header("Location: login.php?logout=1");
exit();
