<?php
// index.php (migrado a layout reutilizable)
require_once __DIR__ . '/config/session.php';
require_once __DIR__ . '/config/auth.php';
requireLogin();
requireRegularArea();

date_default_timezone_set('America/Lima');
$valoresPermitidos = [10, 50, 100, 150, 200, 250, 300, 350, 400, 450, 500];

// Variables de layout
$pageTitle = 'MÓDULO LISTAR CLIENTES';
$activeMenu = 'clientes';

// Inicio de layout común (head + header + sidebar)
include __DIR__ . '/view/layout/layout_start.php';
?>

<main class="min-h-screen py-4 pr-4 md:pr-6 grid grid-cols-1 items-start border min-w-full">
  <?php include __DIR__ . '/view/cliente/filters_min.php'; ?>
  <?php include __DIR__ . '/view/cliente/tabla.php'; ?>
</main>

<?php // Modales y componentes requeridos por los scripts de clientes ?>
<?php include __DIR__ . '/view/cliente/modal.php'; ?>

<!-- Scripts específicos de la página -->
<script src="<?php echo $base ?>assets/js/modal-cliente.js"></script>
<script src="<?php echo $base ?>assets/js/modal-distrito.js"></script>
<script src="<?php echo $base ?>script.js"></script>
<script type="module" src="<?php echo $base ?>assets/js/listar-clientes/dashboard-clientes.js"></script>
<script src="<?php echo $base ?>assets/js/listar-clientes/modal-form.js"></script>
<script src="<?php echo $base ?>assets/js/listar-clientes/tabla.js"></script>
<script src="<?php echo $base ?>assets/js/listar-clientes/tabla-eliminados.js"></script>
<script src="<?php echo $base ?>assets/js/listar-clientes/tabla-ui.js"></script>

<?php include __DIR__ . '/view/layout/layout_end.php'; ?>
