# Integracion CRM <-> Mautic (resumen de conversacion)

## Alcance y objetivos
- El CRM mantiene la base principal de contactos.
- Mautic se usa para campañas, envios y seguimiento (opens/clicks).
- Sincronizacion principal:
  - CRM -> Mautic: contactos (contacto_emails).
  - Mautic -> CRM: campañas, contactos en campañas y eventos.

## Direccion de datos
- Contactos: solo de CRM hacia Mautic (push).
- Campañas y eventos: de Mautic hacia CRM (pull).

## Campos minimos a sincronizar (CRM -> Mautic)
- nombre
- email
- telefono
- empresa

## Segmentos (lead_lists) usados en Mautic
1. CONTACTOS DESUSCRITOS (contactunsubscribe)
2. CONTACTOS REBOTADO EMAILS (emailsbounced)
3. CONTACTOS ENVIO DE PRUEBA DE EMAILS (emailstest)
4. CONTACTOS QUE NO ABRIERON EL CORREO (contactnotopenmail)
5. CONTACTOS QUE ABRIERON EL CORREO (contactopenmail)
6. CONTACTOS QUE HICIERON CLICK EN EL CORREO (contactclickmail)
7. TOTAL CONTACTOS (fullcontact)
8. CONTACT ASIGNADOS A ENVIO (contact-asig-envio)
9. CONTACTOS PROVENIENTES DE CRM (contactcrm)

Notas:
- #4/#5/#6 se usan solo para tracking (no afectan el bucle 8 <-> 9).
- El reset de #4/#5/#6 se hace manual en Mautic (no via API).

## Tablas locales (CRM)
- contacto
- contacto_emails (emails por contacto)
- campanias
- campania_contacto (relacion campania-contacto)
- campania_contacto_eventos (nueva, para opens/clicks)

## Mapeo de tablas Mautic
- leads -> contactos
- lead_lists -> contacto_emails (asignacion de contactos a segmentos)
- campaigns -> campanias
- campaign_leads -> campania_contacto
- segmentos open/click/no-open -> campania_contacto_eventos

## Recomendacion de autenticacion
- API de Mautic requiere credenciales web (no credenciales de base de datos).
- Se soporta Basic Auth y OAuth2 por instancia.
- OAuth2 requiere client_id, client_secret y refresh_token.

## Multi Mautic (varias instancias)
- Se recomienda una tabla para registrar instancias Mautic:
  - id, base_url, auth_type, api_user/api_pass u oauth_client_id/secret/refresh_token, activo, last_sync_at
- El cron recorre instancias activas y sincroniza cada una.
- Campanias con el mismo nombre se diferencian por instancia (mautic_instancia_id).

## Cron (sincronizacion Mautic -> CRM)
- Ejecutar cada 5 minutos (estandar Mautic). Opcional: cada 2 minutos.
- Ejemplo (cPanel / Linux):
  - */5 * * * * /usr/local/bin/php /home/USUARIO/public_html/tu_ruta/cron_sync_mautic.php

Script sugerido:
- controller/mautic/cron_sync_mautic.php

Endpoint manual (opcional):
- controller/mautic/SyncController.php?action=full_sync

Vista de configuracion en CRM:
- view/mautic/index.php

Campos OAuth2 por instancia:
- auth_type = oauth2
- oauth_client_id
- oauth_client_secret
- oauth_redirect_uri
- oauth_refresh_token (obligatorio para refrescar)
- oauth_access_token (opcional, se actualiza al refrescar)

## Reporte "All Emails"
- Se usa el reporte de Mautic "View Report - All Emails".
- Para mapear columnas se configura en mautic_reportes_map:
  - report_key: all_emails
  - report_id: ID del reporte en Mautic
  - campo_campania: columna que trae el ID de campaña (segun tu reporte)
  - campo_lead_id (opcional): si el reporte expone lead_id
  - campo_email: email_address
  - campo_clicks: clicks (o hits si no existe clicks)
  - campo_date_sent: date_sent
  - campo_date_read: date_read

En tu reporte actual (Mautic 6.0.7), los campos son:
- campaign_id (clel.campaign_id)
- contactId (l.id)
- email_address (es.email_address)
- date_sent (es.date_sent)
- date_read (es.date_read)
- hits (clicks)

## Base URL conocida
- https://mauticcompi.impulsatuestrategiapromocional.com

## Reglas operativas en Mautic (flujo actual)
- Campañas de sistema siempre activas:
  1) ACOPLAMIENTO DE CONTACTOS [CONTAVILIZAR] (unifica y cuenta en TOTAL CONTACTOS).
  2) REMOVER CONTACTOS DESUSCRITOS (mueve a CONTACTOS DESUSCRITOS).
  3) REMOVER CONTACTOS REBOTADOS (mueve a CONTACTOS REBOTADO EMAILS).
- Script PHP mueve contactos:
  - Lunes a sabado: 250 contactos por hora del segmento #9 al #8.
  - Domingo: retorna todos del #8 al #9.
- Todas las campañas de envio usan el segmento #8.
- Solo hay 1 campaña activa por semana.
- Las campañas se programan con fecha/hora de inicio y fin, se activan/desactivan automaticamente.

## Sync de eventos (open/click/no-open)
- Se usa la pertenencia a segmentos:
  - #4 contactnotopenmail -> no_open = 1
- #5 contactopenmail -> open = 1
- #6 contactclickmail -> clicks = 1 (y abre tambien)
- Se guarda un registro por contacto+campaña (acumulativo por campaña).
- La fecha se toma de dateAdded del segmento si existe, si no se usa fecha de sync.
- El sync de eventos se ejecuta solo para la campaña activa (publicada y dentro de su ventana).

Si se configura el reporte All Emails, el sync usa clicks reales del reporte
en vez de los segmentos.

## Pendientes para implementar
- Crear usuario API en cada Mautic (Basic Auth).
- Definir estructura exacta de tablas de mapeo:
  - mautic_contacto_map (contacto_id, mautic_lead_id, last_sync_at)
  - mautic_lista_map (contacto_email_id, mautic_list_id, last_sync_at)
  - mautic_campania_map (campania_id, mautic_campaign_id, last_sync_at)
- Definir estrategia de sync incremental (por fecha o id).
- Confirmar si se necesita conteo real de clicks; por ahora se usa 0/1 por pertenencia a segmentos.
