<?php
header('Content-Type: application/json');
require_once __DIR__ . '/conexion.php';

try {
    $page  = isset($_GET['page'])  ? (int) $_GET['page']  : 1;
    $limit = isset($_GET['limit']) ? (int) $_GET['limit'] : 10;
    $filtro  = isset($_GET['filtro'])  ? (string) $_GET['filtro'] : '';
    $campo = isset($_GET['campo']) ? (string) $_GET['campo'] : 'todos';
    $allowedCampos = ['todos', 'id', 'nombre', 'usuario'];
    if (!in_array($campo, $allowedCampos, true)) {
        $campo = 'todos';
    }

    $resultList = $userModel->readPageFilter($filtro, $page, $limit, $campo);
    $total = $resultList['filtering']
        ? $userModel->countAll($filtro, $campo)
        : $userModel->countAll('');
    echo json_encode([
        'success' => true,
        'data'    => $resultList['data'],
        'total'   => $total,
        'filtering'=>$resultList['filtering']
    ]);
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => "Excepción en la base de datos: " . $e->getMessage()
    ]);
}
