<?php
// Asegurar que la respuesta siempre sea JSON
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Lima');

// Limpiar buffer de salida
if (ob_get_level() > 0) {
    ob_end_clean();
}
ob_start();

require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../models/ContactoProveedorModel.php';

ob_end_clean();

requireLogin();
requireModuleAccess('proveedor_contactos');

$currentUserId = isset($_SESSION['idusuario']) ? (int)$_SESSION['idusuario'] : null;

try {
    $db = (new Database())->getConnection();
    $contacto = new ContactoProveedorModel($db);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a base de datos: ' . $e->getMessage()]);
    exit();
}

$action = $_REQUEST['action'] ?? 'list';

try {
    switch ($action) {
        case 'list':
            $q = $_GET['q'] ?? '';
            $campo = $_GET['campo'] ?? '';
            $provee_id = (int)($_GET['provee_id'] ?? 0);
            $page = max(1, (int)($_GET['page'] ?? 1));
            $limit = max(1, (int)($_GET['limit'] ?? 25));
            $offset = ($page - 1) * $limit;
            $filters = [];
            if ($q !== '') $filters['q'] = $q;
            if ($campo !== '') $filters['campo'] = $campo;
            if ($provee_id > 0) $filters['provee_id'] = $provee_id;
            $rows = $contacto->list($filters, $limit, $offset);
            $total = $contacto->count($filters);
            // Enriquecer con nombre del usuario creador
            require_once __DIR__ . '/../../models/User.php';
            foreach ($rows as $idx => $r) {
                $uid = isset($r['user_id']) ? (int)$r['user_id'] : 0;
                if ($uid > 0) {
                    try {
                        $uModel = new User($db, $currentUserId);
                        $uModel->idusuario = $uid;
                        $uInfo = $uModel->readOne();
                        if ($uInfo) {
                            $rows[$idx]['user_fullname'] = trim(($uInfo->nombres ?? '') . ' ' . ($uInfo->apellidos ?? ''));
                        } else {
                            $rows[$idx]['user_fullname'] = null;
                        }
                    } catch (Throwable $e) {
                        $rows[$idx]['user_fullname'] = null;
                    }
                } else {
                    $rows[$idx]['user_fullname'] = null;
                }
            }
            echo json_encode(['success' => true, 'data' => $rows, 'total' => $total]);
            break;

        case 'get':
            $id = (int)($_GET['id'] ?? 0);
            if ($id <= 0) throw new InvalidArgumentException('ID inválido');
            $row = $contacto->get($id);
            if (!$row) { echo json_encode(['success' => false, 'message' => 'No encontrado']); break; }
            // Enriquecer con usuario
            $userInfo = null;
            if (!empty($row['user_id'])) {
                try {
                    $uModel = new User($db, $currentUserId);
                    $uModel->idusuario = (int)$row['user_id'];
                    $uLoaded = $uModel->readOne();
                    if ($uLoaded) {
                        $userInfo = ['id' => (int)$uLoaded->idusuario, 'nombres' => $uLoaded->nombres, 'apellidos' => $uLoaded->apellidos];
                    }
                } catch (Throwable $e) {
                    $userInfo = null;
                }
            }
            if ($userInfo && empty($row['user_fullname'])) {
                $row['user_fullname'] = trim(($userInfo['nombres'] ?? '') . ' ' . ($userInfo['apellidos'] ?? ''));
            }
            if (empty($row['empresa']) && !empty($row['proveedor_razon_comercial'])) {
                $row['empresa'] = $row['proveedor_razon_comercial'];
            }
            echo json_encode(['success' => true, 'data' => $row, 'user' => $userInfo]);
            break;

        case 'create':
            $input = json_decode(file_get_contents('php://input'), true) ?? $_POST;
            $proveeId = (int)($input['provee_id'] ?? 0);
            if ($proveeId <= 0) throw new InvalidArgumentException('Proveedor inválido');
            if (empty($input['nombre'])) throw new InvalidArgumentException('Nombre es requerido');
            // Obtener user_id de la sesión
            $input['user_id'] = $_SESSION['idusuario'] ?? 0;
            if (empty($input['user_id'])) {
                throw new InvalidArgumentException('Usuario no autenticado.');
            }
            $cid = $contacto->create($proveeId, $input);
            echo json_encode(['success' => true, 'id' => $cid]);
            break;

        case 'update':
            $input = json_decode(file_get_contents('php://input'), true);
            if (!is_array($input)) $input = $_POST;
            $id = (int)($input['id'] ?? 0);
            if ($id <= 0) throw new InvalidArgumentException('ID inválido');
            $currentUserId = (int)($_SESSION['idusuario'] ?? 0);
            if ($currentUserId > 0) {
                $input['user_id'] = $currentUserId;
            }
            $ok = $contacto->update($id, $input);
            echo json_encode(['success' => (bool)$ok]);
            break;

        case 'delete':
            $id = (int)($_POST['id'] ?? 0);
            if ($id <= 0) throw new InvalidArgumentException('ID inválido');
            $ok = $contacto->delete($id);
            echo json_encode(['success' => (bool)$ok]);
            break;

        default:
            echo json_encode(['success' => false, 'message' => 'Acción no soportada']);
    }
} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
