<?php
error_reporting(E_ALL & ~E_DEPRECATED & ~E_USER_DEPRECATED);
ini_set('display_errors', 1);
set_time_limit(0);

$logFile = __DIR__ . '/sync_mautic.log';
function logMessage($msg)
{
    global $logFile;
    file_put_contents($logFile, '[' . date('Y-m-d H:i:s') . '] ' . $msg . PHP_EOL, FILE_APPEND);
}

require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../models/mautic/MauticSync.php';

date_default_timezone_set('America/Lima');

try {
    $db = (new Database())->getConnection();
    $sync = new MauticSync($db);
    $result = $sync->syncAll();
    logMessage('OK ' . json_encode($result));
    echo json_encode($result);
} catch (Throwable $e) {
    $errorMsg = 'ERROR: ' . $e->getMessage();
    logMessage($errorMsg);
    echo json_encode(['success' => false, 'message' => $errorMsg]);
}
