<?php
require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../models/mautic/MauticSync.php';

requireLogin();
requireModuleAccess('campanas');

header('Content-Type: application/json; charset=utf-8');

try {
    set_time_limit(0);
    $db = (new Database())->getConnection();
    $sync = new MauticSync($db);
    $action = $_GET['action'] ?? 'full_sync';
    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 0;

    switch ($action) {
        case 'push_contactos':
            echo json_encode($sync->syncContactsOnly($limit));
            break;
        case 'pull_campanas':
            echo json_encode($sync->syncCampaignsOnly());
            break;
        case 'full_sync':
        default:
            echo json_encode($sync->syncAll($limit));
            break;
    }
} catch (Throwable $e) {
    http_response_code(400);
    error_log('Mautic sync error: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
