<?php
header('Content-Type: application/json');
ob_start();

require_once __DIR__ . '/../cliente_conexion.php';

try {
    $data = json_decode(file_get_contents('php://input'), true);
    $idcliente = isset($data['idcliente']) ? (int)$data['idcliente'] : 0;

    if (!$idcliente) {
        http_response_code(400);
        ob_clean();
        echo json_encode(['success' => false, 'message' => 'ID de cliente inválido']);
        exit;
    }

    $cliente->idcliente = $idcliente;
    $ok = $cliente->delete();

    ob_clean();
    echo json_encode([
        'success' => (bool)$ok,
        'message' => $ok ? 'Cliente eliminado' : 'No se pudo eliminar el cliente'
    ]);
} catch (Throwable $e) {
    http_response_code(500);
    ob_clean();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

ob_end_flush();
