<?php
header('Content-Type: application/json');

require_once __DIR__ . '/../cliente_conexion.php';

try {
    $mes = isset($_GET['mes']) ? (int) $_GET['mes'] : 0;
    if ($mes < 0 || $mes > 12) {
        echo json_encode(['success' => false, 'message' => 'Mes invalido']);
        exit;
    }
    $rows = $cliente->getCumpleaniosAniversarios($mes > 0 ? $mes : null);
    echo json_encode(['success' => true, 'data' => $rows]);
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => "Excepcion en la base de datos: " . $e->getMessage()
    ]);
}
