<?php
header('Content-Type: application/json; charset=utf-8');
date_default_timezone_set('America/Lima');

require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../models/CategoriaModel.php';

requireLogin();
requireModuleAccess('categorias');

try {
    $db = (new Database())->getConnection();
    $categoria = new CategoriaModel($db);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error de conexión a base de datos: ' . $e->getMessage()]);
    exit();
}

$action = $_REQUEST['action'] ?? 'list';

try {
    switch ($action) {
        case 'list': {
            $q = trim((string)($_GET['q'] ?? ''));
            $rows = $categoria->list($q);
            echo json_encode(['success' => true, 'data' => $rows]);
            break;
        }

        case 'get': {
            $id = (int)($_GET['id'] ?? 0);
            if ($id <= 0) {
                throw new InvalidArgumentException('ID inválido');
            }
            $row = $categoria->get($id);
            echo json_encode(['success' => (bool)$row, 'data' => $row]);
            break;
        }

        case 'create': {
            $input = json_decode(file_get_contents('php://input'), true) ?? $_POST;
            $name = trim((string)($input['name_cat'] ?? ''));
            if ($name === '') {
                echo json_encode(['success' => false, 'message' => 'El nombre de la categoría es obligatorio.']);
                break;
            }
            $input['name_cat'] = $name;
            if (isset($input['descripcion'])) {
                $input['descripcion'] = trim((string)$input['descripcion']);
            }
            if (!isset($input['status']) || $input['status'] === '') {
                $input['status'] = 1;
            }
            $id = $categoria->create($input);
            echo json_encode(['success' => true, 'id' => $id]);
            break;
        }

        case 'update': {
            $input = json_decode(file_get_contents('php://input'), true);
            if (!is_array($input)) {
                $input = $_POST;
            }
            $id = (int)($input['id'] ?? 0);
            if ($id <= 0) {
                throw new InvalidArgumentException('ID inválido');
            }
            if (array_key_exists('name_cat', $input)) {
                $input['name_cat'] = trim((string)$input['name_cat']);
                if ($input['name_cat'] === '') {
                    echo json_encode(['success' => false, 'message' => 'El nombre de la categoría es obligatorio.']);
                    break;
                }
            }
            if (array_key_exists('descripcion', $input)) {
                $input['descripcion'] = trim((string)$input['descripcion']);
            }
            $ok = $categoria->update($id, $input);
            echo json_encode(['success' => (bool)$ok]);
            break;
        }

        case 'delete': {
            $id = (int)($_POST['id'] ?? 0);
            if ($id <= 0) {
                throw new InvalidArgumentException('ID inválido');
            }
            $ok = $categoria->delete($id);
            echo json_encode(['success' => (bool)$ok]);
            break;
        }

        default:
            echo json_encode(['success' => false, 'message' => 'Acción no soportada']);
    }
} catch (Throwable $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
