<?php
require_once __DIR__ . '/../../models/Campanas.php';

class CampanasController
{
    private $model;

    public function __construct()
    {
        $this->model = new Campanas();
    }

    public function index()
    {
        return $this->model->obtenerTodas();
    }

    public function crear($data)
    {
        return $this->model->crear($data);
    }

    public function obtener($id)
    {
        return $this->model->obtenerPorId($id);
    }

    public function actualizar($id, $data)
    {
        return $this->model->actualizar($id, $data);
    }

    public function eliminar($id)
    {
        return $this->model->eliminar($id);
    }

    public function sumarRegistro($id)
    {
        return $this->model->incrementarRegistro($id);
    }
}

if (isset($_GET['action'])) {

    $controller = new CampanasController();

    switch ($_GET['action']) {

        case 'crear':
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $controller->crear($_POST);
                header("Location: ../../view/campanas/index.php");
                exit;
            }
            break;

        case 'eliminar':
            if (isset($_GET['id'])) {
                $controller->eliminar($_GET['id']);
                header("Location: ../../view/campanas/index.php");
                exit;
            }
            break;

        case 'actualizar':
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['id'])) {
                $controller->actualizar($_GET['id'], $_POST);
                header("Location: ../../view/campanas/index.php");
                exit;
            }
            break;

        case 'sumarRegistro':
            if (isset($_GET['id'])) {
                $controller->sumarRegistro($_GET['id']);
                echo "OK";
                exit;
            }
            break;

        default:
            echo "Acción no válida";
            break;
    }
}
