<?php
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../models/Campania.php';

class CampaniaController {

    private $model;

    public function __construct() {
        $database = new Database();
        $db = $database->getConnection();

        $id_usuario = $_SESSION['id_usuario'] ?? null;
        $this->model = new Campania($db, $id_usuario);
    }

    public function index() {
        return $this->model->listarPrincipales();
    }

    public function listarArbol(): array {
        $rows = $this->model->listarTodas();
        $byParent = [];
        foreach ($rows as $row) {
            $parentKey = $row['parent_id'] === null ? 0 : (int)$row['parent_id'];
            if (!isset($byParent[$parentKey])) {
                $byParent[$parentKey] = [];
            }
            $byParent[$parentKey][] = $row;
        }

        $buildTree = function ($parentId) use (&$buildTree, $byParent) {
            $items = $byParent[$parentId] ?? [];
            foreach ($items as &$item) {
                $itemId = (int)$item['id_campania'];
                $item['children'] = $buildTree($itemId);
            }
            return $items;
        };

        return $buildTree(0);
    }

    /* ===================== CREAR ===================== */
    public function crear() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->model->crear($_POST);
            header('Location: ../../view/campanas/index.php');
            exit;
        }
    }

    /* ===================== ACTUALIZAR ===================== */
    public function actualizar() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_GET['id'])) {
            $this->model->actualizar((int)$_GET['id'], $_POST);
            header('Location: ../../view/campanas/index.php');
            exit;
        }
    }

    /* ===================== ELIMINAR ===================== */
    public function eliminar() {
        if (isset($_GET['id'])) {
            $this->model->eliminar((int)$_GET['id']);
            header('Location: ../../view/campanas/index.php');
            exit;
        }
    }
}

/* ===================== ROUTER SIMPLE ===================== */
$action = $_GET['action'] ?? null;

if ($action && method_exists('CampaniaController', $action)) {
    $controller = new CampaniaController();
    $controller->$action();
}
