<?php
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../models/CampaniaContacto.php';

class CampaniaContactoController {

    private $model;

    public function __construct() {
        $database = new Database();
        $db = $database->getConnection();

        $this->model = new CampaniaContacto($db);
    }

    public function contactosPorCampania(int $campaniaId): array {
        return $this->model->obtenerContactosPorCampania($campaniaId);
    }

    public function pendientesPorCampania(int $campaniaId): array {
        return $this->model->obtenerPendientesPorCampania($campaniaId);
    }
}

if (isset($_GET['action'])) {

    $controller = new CampaniaContactoController();

    switch ($_GET['action']) {
        case 'contactos':
            if (!isset($_GET['id'])) {
                http_response_code(400);
                echo json_encode(['error' => 'ID de campana requerido']);
                exit;
            }

            header('Content-Type: application/json');
            echo json_encode(
                $controller->contactosPorCampania((int) $_GET['id'])
            );
            exit;
        case 'pendientes':
            if (!isset($_GET['id'])) {
                http_response_code(400);
                echo json_encode(['error' => 'ID de campana requerido']);
                exit;
            }

            header('Content-Type: application/json');
            echo json_encode(
                $controller->pendientesPorCampania((int) $_GET['id'])
            );
            exit;
        default:
            http_response_code(404);
            echo json_encode(['error' => 'Accion no valida']);
            exit;
    }
}
